package org.geotools.renderer.style.customshape;

import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class PlusShapeCreator extends AbstractShapeCreator {
	public String getShapeName() {
		return "plus";
	}
	
	public Shape createShape(Parameter<String>... parameters) {
		GeneralPath gp = new GeneralPath();
		gp.moveTo(-0.5f, 0);
		gp.lineTo(0.5f, 0);
		gp.moveTo(0, -0.5f);
		gp.lineTo(0, 0.5f);

		return gp;
	}
	
    public String buildShapeSpecification()
    {
        return getShapeName();
    }   
	

}
