/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: XShapeCreator.java
 * created: Nov 4, 2009
 */
package org.geotools.renderer.style.customshape;

import java.awt.Shape;
import java.awt.geom.GeneralPath;

/**
 * Creates an X shape.
 * @author fabiomano
 */
public class XShapeCreator extends AbstractShapeCreator
{

    /* (non-Javadoc)
     * @see org.geotools.renderer.style.customshape.AbstractShapeCreator#createShape(org.geotools.renderer.style.customshape.AbstractShapeCreator.Parameter<java.lang.String>[])
     */
    @Override
    protected Shape createShape(Parameter<String>... parameters)
    {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0, 0);
        gp.lineTo(1, 1);
        gp.moveTo(1, 0);
        gp.lineTo(0, 1);

        return gp;    
    }

    /* (non-Javadoc)
     * @see org.geotools.renderer.style.customshape.ShapeCreator#getShapeName()
     */
    @Override
    public String getShapeName()
    {
        return "x";
    }
    
    public String buildShapeSpecification()
    {
        return getShapeName();
    }   
    
}
