/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 * 
 *    (C) 2005-2008, Open Source Geospatial Foundation (OSGeo)
 *    
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.renderer.style.customshape;

import java.awt.Shape;
import java.awt.geom.GeneralPath;

/**
 * ShapeCreator for a times ("x") shape.
 * 
 * @author fmoura
 */
public class TimesShapeCreator extends AbstractShapeCreator
{
    public String getShapeName()
    {
        return "times";
    }

    public Shape createShape(Parameter<String>... parameters)
    {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(-0.5f, 0.5f);
        gp.lineTo(0.5f, -0.5f);
        gp.moveTo(-0.5f, -0.5f);
        gp.lineTo(0.5f, 0.5f);
        return gp;
    }
    
    public String buildShapeSpecification()
    {
        return getShapeName();
    }    
}
