/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.customshape;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.renderer.style.customshape.BackslashShapeCreator;
import org.geotools.renderer.style.customshape.DiamondShapeCreator;
import org.geotools.renderer.style.customshape.DotShapeCreator;
import org.geotools.renderer.style.customshape.HatchShapeCreator;
import org.geotools.renderer.style.customshape.HorizontalLineShapeCreator;
import org.geotools.renderer.style.customshape.PlusShapeCreator;
import org.geotools.renderer.style.customshape.RectangleShapeCreator;
import org.geotools.renderer.style.customshape.ShapeCreator;
import org.geotools.renderer.style.customshape.SlashShapeCreator;
import org.geotools.renderer.style.customshape.TimesShapeCreator;
import org.geotools.renderer.style.customshape.VerticalLineShapeCreator;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;

public class CustomShapeMarkFactory
implements MarkFactory {
    private static final String SHAPE_PREFIX = "customshape://";
    private static final Logger LOGGER;
    private static Map<String, ShapeCreator> shapeCreatorRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerShapeCreator(ShapeCreator shapeCreator) {
        if (shapeCreator == null) {
            throw new IllegalArgumentException("shape creator can't be null.");
        }
        Map<String, ShapeCreator> map = shapeCreatorRegistry;
        synchronized (map) {
            shapeCreatorRegistry.put(shapeCreator.getShapeName(), shapeCreator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterShapeCreator(String name) {
        if (name == null) {
            throw new IllegalArgumentException("shape creator name can't be null.");
        }
        Map<String, ShapeCreator> map = shapeCreatorRegistry;
        synchronized (map) {
            shapeCreatorRegistry.remove(name);
        }
    }

    public static String buildWellKnownName(String shapeSpecification) {
        if (shapeSpecification == null) {
            throw new IllegalArgumentException("shape specification can't be null.");
        }
        return SHAPE_PREFIX + shapeSpecification;
    }

    public Shape getShape(Graphics2D graphics, Expression symbolUrl, Feature feature) throws Exception {
        ShapeCreator creator;
        if (symbolUrl == null) {
            return null;
        }
        String wellKnownName = (String)symbolUrl.evaluate((Object)feature, String.class);
        if (!wellKnownName.startsWith(SHAPE_PREFIX)) {
            return null;
        }
        String shapeSpecification = wellKnownName.substring(SHAPE_PREFIX.length());
        Shape shape = null;
        Iterator<ShapeCreator> i$ = shapeCreatorRegistry.values().iterator();
        while (i$.hasNext() && (shape = (creator = i$.next()).createShape(shapeSpecification)) == null) {
        }
        return shape;
    }

    static {
        ShapeCreator[] defaultShapeCreators;
        LOGGER = Logging.getLogger((String)"org.geotools.rendering");
        shapeCreatorRegistry = new HashMap<String, ShapeCreator>();
        for (ShapeCreator shapeCreator : defaultShapeCreators = new ShapeCreator[]{new VerticalLineShapeCreator(), new HorizontalLineShapeCreator(), new SlashShapeCreator(), new BackslashShapeCreator(), new DotShapeCreator(), new PlusShapeCreator(), new TimesShapeCreator(), new HatchShapeCreator(), new RectangleShapeCreator(), new DiamondShapeCreator()}) {
            shapeCreatorRegistry.put(shapeCreator.getShapeName(), shapeCreator);
        }
    }
}

