/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.customshape;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.apache.log4j.Logger;
import org.geotools.renderer.style.customshape.AbstractShapeCreator;
import org.geotools.renderer.style.shape.ExplicitBoundsShape;

public class HatchShapeCreator
extends AbstractShapeCreator {
    private static final double MIN_SIN_COS_VALUE = 0.01;
    private static final String SHAPE_NAME = "hatch";
    private static final String ANGLE_PARAMETER_NAME = "angle";
    private static final String XREPETITIONS_PARAMETER_NAME = "xrepetitions";
    private static final String YREPETITIONS_PARAMETER_NAME = "yrepetitions";
    private static Logger _logger = Logger.getLogger(HatchShapeCreator.class);

    @Override
    protected Shape createShape(AbstractShapeCreator.Parameter<String> ... parameters) {
        String angleStr = null;
        String xRepetitionsStr = null;
        String yRepetitionsStr = null;
        for (AbstractShapeCreator.Parameter<String> parameter : parameters) {
            if (parameter.getName().equalsIgnoreCase(ANGLE_PARAMETER_NAME)) {
                angleStr = parameter.getValue();
                continue;
            }
            if (parameter.getName().equalsIgnoreCase(XREPETITIONS_PARAMETER_NAME)) {
                xRepetitionsStr = parameter.getValue();
            }
            if (!parameter.getName().equalsIgnoreCase(YREPETITIONS_PARAMETER_NAME)) continue;
            yRepetitionsStr = parameter.getValue();
        }
        if (angleStr == null) {
            _logger.warn((Object)"Missing required param 'angle'");
            return null;
        }
        double angle = 0.0;
        int xRepetitions = 1;
        int yRepetitions = 1;
        try {
            angle = Double.parseDouble(angleStr);
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)"Parameter 'angle' in invalid format", (Throwable)e);
            return null;
        }
        if (xRepetitionsStr != null) {
            try {
                xRepetitions = Integer.parseInt(xRepetitionsStr);
            }
            catch (NumberFormatException e) {
                _logger.warn((Object)"Parameter 'xrepetitions' in invalid format", (Throwable)e);
                return null;
            }
        }
        if (yRepetitionsStr != null) {
            try {
                yRepetitions = Integer.parseInt(yRepetitionsStr);
                if (yRepetitions <= 0) {
                    throw new NumberFormatException("Must be positive (was '" + yRepetitions + "')");
                }
            }
            catch (NumberFormatException e) {
                _logger.warn((Object)"Parameter 'yrepetitions' in invalid format", (Throwable)e);
                return null;
            }
        }
        return this.createShape(angle, xRepetitions, yRepetitions);
    }

    public Shape createShape(double angle) {
        return this.createShape(angle, 1, 1);
    }

    public Shape createShape(double angle, int xRepetitions, int yRepetitions) {
        if (xRepetitions <= 0) {
            _logger.warn((Object)("Parameter 'xrepetitions' must be positive (was '" + xRepetitions + "')"));
            return null;
        }
        if (yRepetitions <= 0) {
            _logger.warn((Object)("Parameter 'yrepetitions' must be positive (was '" + yRepetitions + "')"));
            return null;
        }
        double sin = Math.sin(Math.PI * angle / 180.0);
        double cos = Math.cos(Math.PI * angle / 180.0);
        if (Math.abs(sin) <= 0.01) {
            return this.createShapeInternalHorizontal(xRepetitions, yRepetitions);
        }
        if (Math.abs(cos) <= 0.01) {
            return this.createShapeInternalVertical(xRepetitions, yRepetitions);
        }
        return this.createShapeInternalAngle(sin, cos, xRepetitions, yRepetitions);
    }

    protected Shape createShapeInternalHorizontal(int xRepetitions, int yRepetitions) {
        double width = 1.0;
        double height = 1.0;
        double tileWidth = width;
        double tileHeight = height / (double)yRepetitions;
        GeneralPath internalShape = new GeneralPath();
        double y = -height / 2.0 + tileHeight / 2.0;
        for (int j = 0; j < yRepetitions; ++j) {
            internalShape.moveTo(-tileWidth / 2.0, y);
            internalShape.lineTo(tileWidth / 2.0, y);
            y += tileHeight;
        }
        ExplicitBoundsShape shape = new ExplicitBoundsShape((Shape)internalShape);
        shape.setBounds((Rectangle2D)new Rectangle2D.Double(-width / 2.0, -height / 2.0, width, height));
        return shape;
    }

    protected Shape createShapeInternalVertical(int xRepetitions, int yRepetitions) {
        double width = 1.0;
        double height = 1.0;
        double tileWidth = width / (double)xRepetitions;
        double tileHeight = height;
        GeneralPath internalShape = new GeneralPath();
        double x = -width / 2.0 + tileWidth / 2.0;
        for (int i = 0; i < xRepetitions; ++i) {
            internalShape.moveTo(x, -tileHeight / 2.0);
            internalShape.lineTo(x, tileHeight / 2.0);
            x += tileWidth;
        }
        ExplicitBoundsShape shape = new ExplicitBoundsShape((Shape)internalShape);
        shape.setBounds((Rectangle2D)new Rectangle2D.Double(-width / 2.0, -height / 2.0, width, height));
        return shape;
    }

    protected Shape createShapeInternalAngle(double sin, double cos, int xRepetitions, int yRepetitions) {
        double yEnd;
        double xEnd;
        int tileRepetitions;
        double width = Math.abs(cos / sin);
        double height = 1.0;
        double tileWidth = width / (double)xRepetitions;
        double tileHeight = height / (double)yRepetitions;
        double backslashFactor = 1.0;
        if (sin * cos < 0.0) {
            backslashFactor = -1.0;
        }
        GeneralPath internalShape = new GeneralPath();
        double xStart = -width / 2.0;
        double yStart = -height / 2.0 * backslashFactor;
        for (int i = 0; i < xRepetitions; ++i) {
            tileRepetitions = Math.min(xRepetitions - i, yRepetitions);
            xEnd = xStart + (double)tileRepetitions * tileWidth;
            yEnd = yStart + (double)tileRepetitions * tileHeight * backslashFactor;
            internalShape.moveTo(xStart, yStart);
            internalShape.lineTo(xEnd, yEnd);
            xStart += tileWidth;
        }
        xStart = -width / 2.0;
        yStart = (-height / 2.0 + tileHeight) * backslashFactor;
        for (int j = 1; j < yRepetitions; ++j) {
            tileRepetitions = Math.min(xRepetitions, yRepetitions - j);
            xEnd = xStart + (double)tileRepetitions * tileWidth;
            yEnd = yStart + (double)tileRepetitions * tileHeight * backslashFactor;
            internalShape.moveTo(xStart, yStart);
            internalShape.lineTo(xEnd, yEnd);
            yStart += tileHeight * backslashFactor;
        }
        ExplicitBoundsShape shape = new ExplicitBoundsShape((Shape)internalShape);
        shape.setBounds((Rectangle2D)new Rectangle2D.Double(-width / 2.0, -height / 2.0, width, height));
        return shape;
    }

    @Override
    public String getShapeName() {
        return SHAPE_NAME;
    }

    public String buildShapeSpecification(double angle, int xRepetitions, int yRepetitions) {
        AbstractShapeCreator.Parameter<String> angleParameter = new AbstractShapeCreator.Parameter<String>(ANGLE_PARAMETER_NAME, String.valueOf(angle));
        AbstractShapeCreator.Parameter<String> xRepetitionsParamenter = new AbstractShapeCreator.Parameter<String>(XREPETITIONS_PARAMETER_NAME, String.valueOf(xRepetitions));
        AbstractShapeCreator.Parameter<String> yRepetitionsParamenter = new AbstractShapeCreator.Parameter<String>(YREPETITIONS_PARAMETER_NAME, String.valueOf(yRepetitions));
        return this.buildShapeSpecification(angleParameter, xRepetitionsParamenter, yRepetitionsParamenter);
    }
}

