/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageReadParam;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.geotools.coverage.Category;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.grassraster.DummyProgressListener;
import org.geotools.gce.grassraster.GrassBinaryImageReader;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.JGrassUtilities;
import org.geotools.gce.grassraster.core.color.JGrassColorTable;
import org.geotools.gce.grassraster.format.GrassCoverageFormat;
import org.geotools.gce.grassraster.metadata.GrassBinaryImageMetadata;
import org.geotools.gce.grassraster.spi.GrassBinaryImageReaderSpi;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrassCoverageReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private GrassBinaryImageReader imageReader = null;
    private String name;
    private PixelInCell cellAnchor = PixelInCell.CELL_CENTER;
    private Interpolation interpolation = Interpolation.getInstance((int)0);
    private boolean useSubSamplingAsRequestedColsRows = false;
    private boolean castDoubleToFloating = false;
    private ProgressListener monitor = new DummyProgressListener();
    private JGrassMapEnvironment jgMapEnvironment;
    private double[] range;
    private String colorRulesString;
    private String categoriesString;

    public GrassCoverageReader(Object input) {
        if (!(input instanceof File)) {
            throw new IllegalArgumentException("Illegal input argument!");
        }
        File file = (File)input;
        this.imageReader = new GrassBinaryImageReader(new GrassBinaryImageReaderSpi());
        this.imageReader.setInput(input);
        this.jgMapEnvironment = new JGrassMapEnvironment(file);
        this.name = file.getName();
    }

    public void setParams(PixelInCell cellAnchor, Interpolation interpolation, boolean useSubSamplingAsColsRows, boolean castDoubleToFloating, ProgressListener monitor) {
        this.useSubSamplingAsRequestedColsRows = useSubSamplingAsColsRows;
        this.castDoubleToFloating = castDoubleToFloating;
        if (monitor != null) {
            this.monitor = monitor;
        }
        if (cellAnchor != null) {
            this.cellAnchor = cellAnchor;
        }
        if (interpolation != null) {
            this.interpolation = interpolation;
        }
    }

    public GridCoverage2D readRaster(JGrassRegion region) throws IOException {
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        double EPS;
        double scaleY;
        double scaleX;
        HashMap<String, String> metaDataTable = ((GrassBinaryImageMetadata)this.imageReader.getImageMetadata(0)).toHashMap();
        double fileNorth = Double.parseDouble(metaDataTable.get("NORTH"));
        double fileSouth = Double.parseDouble(metaDataTable.get("SOUTH"));
        double fileEast = Double.parseDouble(metaDataTable.get("EAST"));
        double fileWest = Double.parseDouble(metaDataTable.get("WEST"));
        int fileRows = Integer.parseInt(metaDataTable.get("NROWS"));
        int fileCols = Integer.parseInt(metaDataTable.get("NCOLS"));
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        try {
            crs = CRS.parseWKT((String)metaDataTable.get("CRS"));
        }
        catch (FactoryException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        ImageReadParam imageReadParam = new ImageReadParam();
        Envelope2D requestedRegionEnvelope = null;
        Rectangle sourceRegion = null;
        int requestedRows = 0;
        int requestedCols = 0;
        double requestedWest = -1.0;
        double requestedEast = -1.0;
        double requestedSouth = -1.0;
        double requestedNorth = -1.0;
        double requestedXres = -1.0;
        double requestedYres = -1.0;
        int subSamplingX = 1;
        int subSamplingY = 1;
        double xDeltaW = 0.0;
        double xDeltaE = 0.0;
        double yDeltaN = 0.0;
        double yDeltaS = 0.0;
        double tmpDxW = 0.0;
        double tmpDyS = 0.0;
        double tmpDyN = 0.0;
        double tmpDxE = 0.0;
        int xPaddingSx = 0;
        int yPaddingTop = 0;
        if (region != null) {
            requestedRows = region.getRows();
            requestedCols = region.getCols();
            requestedWest = region.getWest();
            requestedEast = region.getEast();
            requestedSouth = region.getSouth();
            requestedNorth = region.getNorth();
            requestedXres = region.getWEResolution();
            requestedYres = region.getNSResolution();
            scaleX = (double)fileCols / (fileEast - fileWest);
            scaleY = (double)fileRows / (fileNorth - fileSouth);
            EPS = 0.0;
            xmin = (int)Math.floor((requestedWest - fileWest) * scaleX + EPS);
            xmax = (int)Math.ceil((requestedEast - fileWest) * scaleX - EPS);
            ymin = (int)Math.floor((fileNorth - requestedNorth) * scaleY + EPS);
            ymax = (int)Math.ceil((fileNorth - requestedSouth) * scaleY - EPS);
            if (xmin < 0) {
                xPaddingSx = xmin;
                xmin = 0;
            }
            if (ymin < 0) {
                yPaddingTop = ymin;
                ymin = 0;
            }
            sourceRegion = new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
            requestedRegionEnvelope = new Envelope2D((CoordinateReferenceSystem)crs, requestedWest, requestedSouth, requestedEast - requestedWest, requestedNorth - requestedSouth);
            xDeltaW = requestedWest - fileWest;
            yDeltaS = requestedSouth - fileSouth;
            xDeltaE = requestedEast - fileEast;
            yDeltaN = requestedNorth - fileNorth;
            tmpDxW = xDeltaW > 0.0 ? 0.0 : xDeltaW;
            tmpDyS = yDeltaS > 0.0 ? 0.0 : yDeltaS;
            tmpDyN = yDeltaN < 0.0 ? 0.0 : yDeltaN;
            double d = tmpDxE = xDeltaE < 0.0 ? 0.0 : xDeltaE;
            if (!this.useSubSamplingAsRequestedColsRows) {
                JGrassRegion tmpRegion = new JGrassRegion(region);
                tmpRegion.setWEResolution((fileEast - fileWest) / (double)fileCols);
                tmpRegion.setNSResolution((fileNorth - fileSouth) / (double)fileRows);
                subSamplingX = (int)Math.floor((double)tmpRegion.getCols() / (double)requestedCols);
                subSamplingY = (int)Math.floor((double)tmpRegion.getRows() / (double)requestedRows);
                if (subSamplingX == 0) {
                    subSamplingX = 1;
                }
                if (subSamplingY == 0) {
                    subSamplingY = 1;
                }
                if (subSamplingX != subSamplingY) {
                    if (subSamplingX < subSamplingY) {
                        subSamplingY = subSamplingX;
                    } else {
                        subSamplingX = subSamplingY;
                    }
                }
            } else {
                double sourceCols = (requestedEast - requestedWest) / (double)(1 + xPaddingSx / (xmax - xmin)) / requestedXres;
                double sourceRows = (requestedNorth - requestedSouth) / (double)(1 + yPaddingTop / (ymax - ymin)) / requestedYres;
                subSamplingX = (int)Math.round(sourceCols += (double)xPaddingSx);
                subSamplingY = (int)Math.round(sourceRows += (double)yPaddingTop);
                if (subSamplingX < 1) {
                    subSamplingX = 1;
                }
                if (subSamplingY < 1) {
                    subSamplingY = 1;
                }
            }
        } else {
            requestedRows = fileRows;
            requestedCols = fileCols;
            requestedWest = fileWest;
            requestedEast = fileEast;
            requestedSouth = fileSouth;
            requestedNorth = fileNorth;
            scaleX = (double)fileCols / (fileEast - fileWest);
            scaleY = (double)fileRows / (fileNorth - fileSouth);
            EPS = 1.0E-6;
            xmin = (int)Math.floor((requestedWest - fileWest) * scaleX + EPS);
            xmax = (int)Math.ceil((requestedEast - fileWest) * scaleX - EPS);
            ymin = (int)Math.floor((fileNorth - requestedNorth) * scaleY + EPS);
            ymax = (int)Math.ceil((fileNorth - requestedSouth) * scaleY - EPS);
            sourceRegion = new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
            requestedRegionEnvelope = new Envelope2D((CoordinateReferenceSystem)crs, requestedWest, requestedSouth, requestedEast - requestedWest, requestedNorth - requestedSouth);
            if (!this.useSubSamplingAsRequestedColsRows) {
                subSamplingX = 1;
                subSamplingY = 1;
            } else {
                subSamplingX = fileCols;
                subSamplingY = fileRows;
            }
        }
        if (sourceRegion.getWidth() <= 0.0 || sourceRegion.getHeight() <= 0.0) {
            return null;
        }
        imageReadParam.setSourceRegion(sourceRegion);
        imageReadParam.setSourceSubsampling(subSamplingX, subSamplingY, 0, 0);
        RenderedImage finalImage = null;
        BufferedImage image = this.imageReader.read(0, imageReadParam, this.useSubSamplingAsRequestedColsRows, this.castDoubleToFloating, this.monitor);
        this.imageReader.dispose();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (requestedSouth < fileSouth || requestedWest < fileWest || requestedEast > fileEast || requestedNorth > fileNorth) {
            double totalHeigth = requestedNorth - tmpDyN - (requestedSouth - tmpDyS);
            int xPaddingDx = 0;
            if (xDeltaE > 0.0) {
                xPaddingDx = (int)Math.round(xDeltaE * (double)imageWidth / (requestedEast - tmpDxE - (requestedWest - tmpDxW)));
            }
            int yPaddingBottom = 0;
            if (yDeltaS < 0.0) {
                yPaddingBottom = (int)Math.round(yDeltaS * (double)imageHeight / totalHeigth);
            }
            RenderedImage translatedImage = this.setPadding(xPaddingSx, xPaddingDx, yPaddingTop, yPaddingBottom, image);
            finalImage = requestedRows != imageHeight || requestedCols != imageWidth ? this.scaleJAIImage(requestedCols, requestedRows, translatedImage) : translatedImage;
        } else {
            finalImage = requestedRows != imageHeight || requestedCols != imageWidth ? this.scaleJAIImage(requestedCols, requestedRows, image) : image;
        }
        if (finalImage instanceof RenderedOp) {
            RenderedOp rOp = (RenderedOp)finalImage;
            finalImage = rOp.getAsBufferedImage();
        }
        double min = JGrassMapEnvironment.defaultMapMin;
        double max = JGrassMapEnvironment.defaultMapMax;
        File rangeFile = this.jgMapEnvironment.getCELLMISC_RANGE();
        if (rangeFile.exists()) {
            FileInputStream is = new FileInputStream(rangeFile);
            byte[] numbers = new byte[16];
            int testread = ((InputStream)is).read(numbers);
            ((InputStream)is).close();
            if (testread == 16) {
                ByteBuffer rangeBuffer = ByteBuffer.wrap(numbers);
                min = rangeBuffer.getDouble();
                max = rangeBuffer.getDouble();
            }
        }
        this.range = new double[]{min, max};
        GridSampleDimension band = this.createGridSampleDimension(metaDataTable, this.range);
        band = band.geophysics(true);
        GridToEnvelopeMapper g2eMapper = new GridToEnvelopeMapper();
        g2eMapper.setEnvelope((Envelope)requestedRegionEnvelope);
        g2eMapper.setGridRange((GridEnvelope)new GridEnvelope2D(0, 0, requestedCols, requestedRows));
        g2eMapper.setPixelAnchor(this.cellAnchor);
        MathTransform gridToEnvelopeTransform = g2eMapper.createTransform();
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D coverage2D = factory.create((CharSequence)this.name, finalImage, (CoordinateReferenceSystem)crs, gridToEnvelopeTransform, new GridSampleDimension[]{band}, null, null);
        return coverage2D;
    }

    private RenderedImage setPadding(int xPaddingSx, int xPaddingDx, int yPaddingTop, int yPaddingBottom, RenderedImage image) {
        ParameterBlock block = new ParameterBlock();
        block.addSource(image);
        block.add(Math.abs(xPaddingSx));
        block.add(Math.abs(0));
        block.add(Math.abs(yPaddingTop));
        block.add(Math.abs(0));
        block.add(new BorderExtenderConstant(new double[]{Double.NaN}));
        RenderedOp paddedImage = JAI.create((String)"Border", (ParameterBlock)block);
        block = new ParameterBlock();
        block.addSource(paddedImage);
        block.add((float)(-xPaddingSx));
        block.add((float)(-yPaddingTop));
        return JAI.create((String)"translate", (ParameterBlock)block);
    }

    private RenderedImage scaleJAIImage(int requestedCols, int requestedRows, RenderedImage translatedImage) {
        ParameterBlock block = new ParameterBlock();
        block.addSource(translatedImage);
        block.add((float)requestedCols / (float)translatedImage.getWidth());
        block.add((float)requestedRows / (float)translatedImage.getHeight());
        block.add(0.0f);
        block.add(0.0f);
        block.add(this.interpolation);
        return JAI.create((String)"scale", (ParameterBlock)block);
    }

    private void printImage(GridCoverage2D coverage2D) {
        RenderedImage renderedImage = coverage2D.getRenderedImage();
        System.out.println("Image dims: " + renderedImage.getWidth() + "/" + renderedImage.getHeight());
        RectIter iter = RectIterFactory.create((RenderedImage)renderedImage, (Rectangle)new Rectangle(0, 0, renderedImage.getWidth(), renderedImage.getHeight()));
        int i = 0;
        while (i < renderedImage.getHeight()) {
            int j = 0;
            while (j < renderedImage.getWidth()) {
                System.out.print(String.valueOf(iter.getSampleDouble()) + " \t");
                iter.nextPixel();
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    private GridSampleDimension createGridSampleDimension(HashMap<String, String> metaDataTable, double[] range) throws IOException {
        String[] colorRulesSplit;
        this.colorRulesString = metaDataTable.get("colorRulesDescriptor");
        this.categoriesString = metaDataTable.get("categoriesDescriptor");
        if (this.colorRulesString.length() > 3 && !this.colorRulesString.matches(".*Infinty.*|.*NaN.*")) {
            colorRulesSplit = this.colorRulesString.split("@@split@@");
        } else {
            List<String> defColorTable = JGrassColorTable.createDefaultColorTable(range, 255);
            colorRulesSplit = defColorTable.toArray(new String[defColorTable.size()]);
            File colrFile = this.jgMapEnvironment.getCOLR();
            JGrassUtilities.makeColorRulesPersistent(colrFile, defColorTable, range, 255);
        }
        int rulesNum = colorRulesSplit.length;
        int COLORNUM = 60000;
        if (colorRulesSplit.length > COLORNUM) {
            COLORNUM = colorRulesSplit.length + 1;
        }
        if (COLORNUM > 65500) {
            COLORNUM = 65500;
        }
        ArrayList<Category> catsList = new ArrayList<Category>();
        double[][] values = new double[rulesNum][2];
        Color[][] colors = new Color[rulesNum][2];
        int i = 0;
        while (i < rulesNum) {
            String colorRule = colorRulesSplit[i];
            JGrassColorTable.parseColorRule(colorRule, values[i], colors[i]);
            if (values[i][0] == values[i][1]) {
                colors[i][1] = colors[i][0];
            }
            ++i;
        }
        Category noData = new Category((CharSequence)"novalue", new Color(Color.WHITE.getRed(), Color.WHITE.getGreen(), Color.WHITE.getBlue(), 0), 0);
        catsList.add(noData);
        double a = (values[values.length - 1][1] - values[0][0]) / (double)(COLORNUM - 1);
        double pmin = 1.0;
        double scale = a;
        if (scale == 0.0) {
            scale = 1.0;
        }
        double offSet = values[0][0] - scale * pmin;
        int previousUpper = -2147483647;
        int i2 = 0;
        while (i2 < rulesNum) {
            StringBuilder sB = new StringBuilder();
            sB.append(this.name);
            sB.append("_");
            sB.append(i2);
            double tmpLower = values[i2][0];
            double tmpUpper = values[i2][1];
            int lower = (int)((tmpLower - values[0][0]) / scale + pmin);
            int upper = (int)((tmpUpper - values[0][0]) / scale + pmin);
            if (lower <= previousUpper) {
                lower = previousUpper + 1;
            }
            if (lower >= upper) {
                upper = lower + 1;
            }
            previousUpper = upper;
            Category dataCategory = new Category((CharSequence)sB.toString(), colors[i2], lower, upper, scale, offSet);
            catsList.add(dataCategory);
            ++i2;
        }
        Category[] array = catsList.toArray(new Category[catsList.size()]);
        return new GridSampleDimension((CharSequence)this.name, array, null);
    }

    public String getLegendString() {
        return this.colorRulesString;
    }

    public String getCategoriesString() {
        return this.categoriesString;
    }

    public double[] getRange() {
        return this.range;
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IllegalArgumentException, IOException {
        GeneralEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                ParameterValue param = (ParameterValue)params[i];
                String name = param.getDescriptor().getName().getCode();
                if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    requestedEnvelope = new GeneralEnvelope((Envelope)gg.getEnvelope2D());
                    dim = gg.getGridRange2D().getBounds();
                }
                ++i;
            }
        }
        if (requestedEnvelope != null && dim != null) {
            DirectPosition lowerCorner = requestedEnvelope.getLowerCorner();
            double[] westSouth = lowerCorner.getCoordinate();
            DirectPosition upperCorner = requestedEnvelope.getUpperCorner();
            double[] eastNorth = upperCorner.getCoordinate();
            JGrassRegion region = new JGrassRegion(westSouth[0], eastNorth[0], westSouth[1], eastNorth[1], dim.height, dim.width);
            return this.readRaster(region);
        }
        return this.readRaster(null);
    }

    public Format getFormat() {
        return new GrassCoverageFormat();
    }
}

