/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.feature.SchemaException;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class DataAccessFinderTest
extends TestCase {
    private static final String MOCK_DS_PARAM_KEY = "MOCK_PARAM_KEY";
    private static final DataAccess<FeatureType, Feature> MOCK_DATAACCESS = new DataAccess<FeatureType, Feature>(){

        public void createSchema(FeatureType featureType) throws IOException {
        }

        public void dispose() {
        }

        public FeatureSource<FeatureType, Feature> getFeatureSource(Name typeName) throws IOException {
            return null;
        }

        public ServiceInfo getInfo() {
            return null;
        }

        public List<Name> getNames() throws IOException {
            return null;
        }

        public FeatureType getSchema(Name name) throws IOException {
            return null;
        }

        public void updateSchema(Name typeName, FeatureType featureType) throws IOException {
        }
    };
    private static final DataStore MOCK_DATASTORE = new DataStore(){

        public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
            return null;
        }

        public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(String typeName) throws IOException {
            return null;
        }

        public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
            return null;
        }

        public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
            return null;
        }

        public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
            return null;
        }

        public LockingManager getLockingManager() {
            return null;
        }

        public SimpleFeatureType getSchema(String typeName) throws IOException {
            return null;
        }

        public String[] getTypeNames() throws IOException {
            return null;
        }

        public FeatureSource<SimpleFeatureType, SimpleFeature> getView(Query query) throws IOException, SchemaException {
            return null;
        }

        public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        }

        public void createSchema(SimpleFeatureType featureType) throws IOException {
        }

        public void dispose() {
        }

        public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(Name typeName) throws IOException {
            return null;
        }

        public ServiceInfo getInfo() {
            return null;
        }

        public List<Name> getNames() throws IOException {
            return null;
        }

        public SimpleFeatureType getSchema(Name name) throws IOException {
            return null;
        }

        public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        }
    };

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetDataStore() throws IOException {
        HashMap<String, Class> params = new HashMap<String, Class>();
        params.put(MOCK_DS_PARAM_KEY, MockUnavailableDataStoreFactory.class);
        DataStore dataStore = DataStoreFinder.getDataStore(params);
        DataAccessFinderTest.assertNull((Object)dataStore);
        params.put(MOCK_DS_PARAM_KEY, MockDataStoreFactory.class);
        dataStore = DataStoreFinder.getDataStore(params);
        DataAccessFinderTest.assertSame((Object)MOCK_DATASTORE, (Object)dataStore);
    }

    public void testGetDataAccess() throws IOException {
        HashMap<String, Class<MockDataAccessFactory>> params = new HashMap<String, Class<MockDataAccessFactory>>();
        params.put(MOCK_DS_PARAM_KEY, MockUnavailableDataStoreFactory.class);
        DataAccess dataStore = DataAccessFinder.getDataStore(params);
        DataAccessFinderTest.assertNull((Object)dataStore);
        params.put(MOCK_DS_PARAM_KEY, MockDataStoreFactory.class);
        dataStore = DataAccessFinder.getDataStore(params);
        DataAccessFinderTest.assertSame((Object)MOCK_DATASTORE, (Object)dataStore);
        params.put(MOCK_DS_PARAM_KEY, MockDataAccessFactory.class);
        dataStore = DataAccessFinder.getDataStore(params);
        DataAccessFinderTest.assertSame(MOCK_DATAACCESS, (Object)dataStore);
    }

    public void testGetAllDataStores() {
        Iterator availableDataStores = DataStoreFinder.getAllDataStores();
        DataAccessFinderTest.assertNotNull((Object)availableDataStores);
        DataAccessFinderTest.assertTrue((boolean)availableDataStores.hasNext());
        DataStoreFactorySpi dsf1 = (DataStoreFactorySpi)availableDataStores.next();
        DataAccessFinderTest.assertTrue((boolean)availableDataStores.hasNext());
        DataStoreFactorySpi dsf2 = (DataStoreFactorySpi)availableDataStores.next();
        DataAccessFinderTest.assertFalse((boolean)availableDataStores.hasNext());
        DataAccessFinderTest.assertNotNull((Object)dsf1);
        DataAccessFinderTest.assertNotNull((Object)dsf2);
        if (dsf1 instanceof MockUnavailableDataStoreFactory) {
            DataAccessFinderTest.assertTrue((boolean)(dsf2 instanceof MockDataStoreFactory));
        } else {
            DataAccessFinderTest.assertTrue((boolean)(dsf1 instanceof MockDataStoreFactory));
            DataAccessFinderTest.assertTrue((boolean)(dsf2 instanceof MockUnavailableDataStoreFactory));
        }
    }

    public void testGetAllDataAccess() {
        Iterator availableDataStores = DataAccessFinder.getAllDataStores();
        DataAccessFinderTest.assertNotNull((Object)availableDataStores);
        DataAccessFinderTest.assertTrue((boolean)availableDataStores.hasNext());
        DataAccessFactory dsf1 = (DataAccessFactory)availableDataStores.next();
        DataAccessFinderTest.assertTrue((boolean)availableDataStores.hasNext());
        DataAccessFactory dsf2 = (DataAccessFactory)availableDataStores.next();
        DataAccessFinderTest.assertTrue((boolean)availableDataStores.hasNext());
        DataAccessFactory dsf3 = (DataAccessFactory)availableDataStores.next();
        DataAccessFinderTest.assertFalse((boolean)availableDataStores.hasNext());
        DataAccessFinderTest.assertNotNull((Object)dsf1);
        DataAccessFinderTest.assertNotNull((Object)dsf2);
        DataAccessFinderTest.assertNotNull((Object)dsf3);
        HashSet classes = new HashSet();
        classes.add(dsf1.getClass());
        classes.add(dsf2.getClass());
        classes.add(dsf3.getClass());
        DataAccessFinderTest.assertTrue((boolean)classes.contains(MockDataAccessFactory.class));
        DataAccessFinderTest.assertTrue((boolean)classes.contains(MockDataStoreFactory.class));
        DataAccessFinderTest.assertTrue((boolean)classes.contains(MockUnavailableDataStoreFactory.class));
    }

    public void testGetAvailableDataStores() {
        Iterator availableDataStores = DataStoreFinder.getAvailableDataStores();
        DataAccessFinderTest.assertNotNull((Object)availableDataStores);
        DataAccessFinderTest.assertTrue((boolean)availableDataStores.hasNext());
        DataStoreFactorySpi dsf = (DataStoreFactorySpi)availableDataStores.next();
        DataAccessFinderTest.assertFalse((boolean)availableDataStores.hasNext());
        DataAccessFinderTest.assertTrue((boolean)(dsf instanceof MockDataStoreFactory));
    }

    public void testGetAvailableDataAccess() {
        Iterator availableDataAccess = DataAccessFinder.getAvailableDataStores();
        DataAccessFinderTest.assertNotNull((Object)availableDataAccess);
        DataAccessFinderTest.assertTrue((boolean)availableDataAccess.hasNext());
        HashSet classes = new HashSet();
        DataAccessFactory daf = (DataAccessFactory)availableDataAccess.next();
        DataAccessFinderTest.assertNotNull((Object)daf);
        classes.add(daf.getClass());
        DataAccessFinderTest.assertTrue((boolean)availableDataAccess.hasNext());
        daf = (DataAccessFactory)availableDataAccess.next();
        DataAccessFinderTest.assertNotNull((Object)daf);
        classes.add(daf.getClass());
        DataAccessFinderTest.assertFalse((boolean)availableDataAccess.hasNext());
        DataAccessFinderTest.assertTrue((boolean)classes.contains(MockDataStoreFactory.class));
        DataAccessFinderTest.assertTrue((boolean)classes.contains(MockDataAccessFactory.class));
    }

    public static class MockUnavailableDataStoreFactory
    extends MockDataStoreFactory {
        public boolean isAvailable() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockDataStoreFactory
    implements DataStoreFactorySpi {
        public boolean isAvailable() {
            return true;
        }

        public boolean canProcess(Map<String, Serializable> params) {
            return MockDataStoreFactory.class.equals((Object)params.get(DataAccessFinderTest.MOCK_DS_PARAM_KEY));
        }

        public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
            return MOCK_DATASTORE;
        }

        public DataStore createNewDataStore(Map params) throws IOException {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public DataAccessFactory.Param[] getParametersInfo() {
            return null;
        }

        public Map<RenderingHints.Key, ?> getImplementationHints() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockDataAccessFactory
    implements DataAccessFactory {
        public boolean isAvailable() {
            return true;
        }

        public boolean canProcess(Map<String, Serializable> params) {
            return MockDataAccessFactory.class.equals((Object)params.get(DataAccessFinderTest.MOCK_DS_PARAM_KEY));
        }

        public DataAccess<FeatureType, Feature> createDataStore(Map<String, Serializable> params) throws IOException {
            return MOCK_DATAACCESS;
        }

        public String getDescription() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public DataAccessFactory.Param[] getParametersInfo() {
            return null;
        }

        public Map<RenderingHints.Key, ?> getImplementationHints() {
            return null;
        }
    }
}

