/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.Capabilities;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Beyond;

public class CapabilitiesTest
extends TestCase {
    public void testCapablities() {
        Capabilities capabilities = new Capabilities();
        capabilities.addType(Beyond.class);
        capabilities.addType(PropertyIsEqualTo.class);
        capabilities.addName("NullCheck");
        capabilities.addName("Mul");
        capabilities.addName("random");
        capabilities.addName("Length", 1);
        capabilities.addName("toDegrees", new String[]{"radians"});
        capabilities.addName("length", new String[]{"expression"});
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        PropertyIsBetween filter = ff.between((Expression)ff.literal(0), (Expression)ff.property("x"), (Expression)ff.literal(2));
        CapabilitiesTest.assertFalse((String)"supports", (boolean)capabilities.supports((Filter)filter));
        filter = ff.equals((Expression)ff.property("x"), (Expression)ff.literal(2));
        CapabilitiesTest.assertTrue((String)"supports", (boolean)capabilities.supports((Filter)filter));
        CapabilitiesTest.assertTrue((String)"fullySupports", (boolean)capabilities.fullySupports((Filter)filter));
        Capabilities capabilities2 = new Capabilities();
        capabilities2.addAll(capabilities);
        capabilities2.addType(And.class);
        CapabilitiesTest.assertTrue((boolean)capabilities2.getContents().getScalarCapabilities().hasLogicalOperators());
        CapabilitiesTest.assertFalse((boolean)capabilities.getContents().getScalarCapabilities().hasLogicalOperators());
    }
}

