/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.math.BigDecimal;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class IsEqualsToImplTest
extends TestCase {
    FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    public void testOperandsSameType() {
        Literal e1 = this.filterFactory.literal(1);
        Literal e2 = this.filterFactory.literal(1);
        PropertyIsEqualTo equal = this.filterFactory.equals((Expression)e1, (Expression)e2);
        IsEqualsToImplTest.assertTrue((boolean)equal.evaluate(null));
    }

    public void testOperandsShort() {
        Literal literalShort42 = this.filterFactory.literal((short)42);
        Literal literalString42 = this.filterFactory.literal((Object)"42");
        Literal literalDouble42 = this.filterFactory.literal(42.0);
        Literal literalLong42 = this.filterFactory.literal(42L);
        Literal literalFloat42 = this.filterFactory.literal(42.0f);
        Literal literalBig42 = this.filterFactory.literal((Object)new BigDecimal(42));
        IsEqualsToImplTest.assertTrue((boolean)this.filterFactory.equals((Expression)literalShort42, (Expression)literalShort42).evaluate(null));
        IsEqualsToImplTest.assertTrue((boolean)this.filterFactory.equals((Expression)literalShort42, (Expression)literalString42).evaluate(null));
        IsEqualsToImplTest.assertTrue((boolean)this.filterFactory.equals((Expression)literalShort42, (Expression)literalDouble42).evaluate(null));
        IsEqualsToImplTest.assertTrue((boolean)this.filterFactory.equals((Expression)literalShort42, (Expression)literalLong42).evaluate(null));
        IsEqualsToImplTest.assertTrue((boolean)this.filterFactory.equals((Expression)literalShort42, (Expression)literalFloat42).evaluate(null));
        IsEqualsToImplTest.assertTrue((boolean)this.filterFactory.equals((Expression)literalShort42, (Expression)literalBig42).evaluate(null));
        IsEqualsToImplTest.assertTrue((boolean)this.filterFactory.equals((Expression)literalShort42, (Expression)literalDouble42).evaluate(null));
    }

    public void testOperandsIntString() {
        Literal e1 = this.filterFactory.literal(1);
        Literal e2 = this.filterFactory.literal((Object)"1");
        PropertyIsEqualTo equal = this.filterFactory.equals((Expression)e1, (Expression)e2);
        IsEqualsToImplTest.assertTrue((boolean)equal.evaluate(null));
    }

    public void testOperandsIntFloatString() {
        Literal e1 = this.filterFactory.literal(1);
        Literal e2 = this.filterFactory.literal((Object)"1.2");
        PropertyIsEqualTo equal = this.filterFactory.equals((Expression)e1, (Expression)e2);
        IsEqualsToImplTest.assertFalse((boolean)equal.evaluate(null));
    }

    public void testOperandsLongInt() {
        Literal e1 = this.filterFactory.literal(1);
        Literal e2 = this.filterFactory.literal(1L);
        PropertyIsEqualTo equal = this.filterFactory.equals((Expression)e1, (Expression)e2);
        IsEqualsToImplTest.assertTrue((boolean)equal.evaluate(null));
    }

    public void testOperandsFloatInt() {
        Literal e1 = this.filterFactory.literal(1.0f);
        Literal e2 = this.filterFactory.literal(1);
        PropertyIsEqualTo equal = this.filterFactory.equals((Expression)e1, (Expression)e2);
        IsEqualsToImplTest.assertTrue((boolean)equal.evaluate(null));
    }

    public void testOperandsDoubleLong() {
        Literal e1 = this.filterFactory.literal(1.0);
        Literal e2 = this.filterFactory.literal(1L);
        PropertyIsEqualTo equal = this.filterFactory.equals((Expression)e1, (Expression)e2);
        IsEqualsToImplTest.assertTrue((boolean)equal.evaluate(null));
    }

    public void testOperandsDoubleLongOutOfRange() {
        Literal e1 = this.filterFactory.literal(new Double(9.223372036854776E18) + 10000.0);
        Literal e2 = this.filterFactory.literal(Long.MAX_VALUE);
        PropertyIsEqualTo equal = this.filterFactory.equals((Expression)e1, (Expression)e2);
        IsEqualsToImplTest.assertFalse((boolean)equal.evaluate(null));
    }

    public void testCaseSensitivity() {
        Literal e1 = this.filterFactory.literal((Object)"foo");
        Literal e2 = this.filterFactory.literal((Object)"FoO");
        PropertyIsEqualTo caseSensitive = this.filterFactory.equal((Expression)e1, (Expression)e2, true);
        IsEqualsToImplTest.assertFalse((boolean)caseSensitive.evaluate(null));
        PropertyIsEqualTo caseInsensitive = this.filterFactory.equal((Expression)e1, (Expression)e2, false);
        IsEqualsToImplTest.assertTrue((boolean)caseInsensitive.evaluate(null));
    }
}

