/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.filter.function.StandardDeviationFunction;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class StandardDeviationFunctionTest
extends FunctionTestSupport {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");

    public StandardDeviationFunctionTest(String testName) {
        super(testName);
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(StandardDeviationFunctionTest.class);
        return suite;
    }

    public void testInstance() {
        Function stdDev = this.ff.function("StandardDeviation", new Expression[]{this.ff.literal((Object)FeatureCollections.newCollection())});
        StandardDeviationFunctionTest.assertNotNull((Object)stdDev);
    }

    public void testGetName() {
        Function equInt = this.ff.function("StandardDeviation", new Expression[]{this.ff.literal((Object)FeatureCollections.newCollection())});
        LOGGER.finer("testGetName");
        StandardDeviationFunctionTest.assertEquals((String)"StandardDeviation", (String)equInt.getName());
    }

    public void testSetNumberOfClasses() throws Exception {
        LOGGER.finer("testSetNumberOfClasses");
        Literal classes = this.ff.literal(3);
        PropertyName exp = this.ff.property("foo");
        StandardDeviationFunction func = (StandardDeviationFunction)this.ff.function("StandardDeviation", new Expression[]{exp, classes});
        StandardDeviationFunctionTest.assertEquals((int)3, (int)func.getClasses());
        classes = this.ff.literal(12);
        func = (StandardDeviationFunction)this.ff.function("StandardDeviation", new Expression[]{exp, classes});
        StandardDeviationFunctionTest.assertEquals((int)12, (int)func.getClasses());
    }

    public void xTestGetValue() throws Exception {
        Literal classes = this.ff.literal(5);
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function("StandardDeviation", new Expression[]{exp, classes});
        FeatureIterator list = this.featureCollection.features();
        SimpleFeature f = (SimpleFeature)list.next();
        int slot = ((Number)func.evaluate((Object)f)).intValue();
        StandardDeviationFunctionTest.assertEquals((int)1, (int)slot);
        f = (SimpleFeature)list.next();
        slot = ((Number)func.evaluate((Object)f)).intValue();
        StandardDeviationFunctionTest.assertEquals((int)4, (int)slot);
        f = (SimpleFeature)list.next();
        slot = ((Number)func.evaluate((Object)f)).intValue();
        StandardDeviationFunctionTest.assertEquals((int)2, (int)slot);
        f = (SimpleFeature)list.next();
        slot = ((Number)func.evaluate((Object)f)).intValue();
        StandardDeviationFunctionTest.assertEquals((int)2, (int)slot);
        f = (SimpleFeature)list.next();
        slot = ((Number)func.evaluate((Object)f)).intValue();
        StandardDeviationFunctionTest.assertEquals((int)2, (int)slot);
        f = (SimpleFeature)list.next();
        slot = ((Number)func.evaluate((Object)f)).intValue();
        StandardDeviationFunctionTest.assertEquals((int)3, (int)slot);
        f = (SimpleFeature)list.next();
        slot = ((Number)func.evaluate((Object)f)).intValue();
        StandardDeviationFunctionTest.assertEquals((int)1, (int)slot);
        f = (SimpleFeature)list.next();
        slot = ((Number)func.evaluate((Object)f)).intValue();
        StandardDeviationFunctionTest.assertEquals((int)1, (int)slot);
    }
}

