/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.Arrays;
import org.geotools.filter.Capabilities;
import org.geotools.filter.function.math.FilterFunction_abs;
import org.geotools.filter.visitor.AbstractCapabilitiesFilterSplitterTests;
import org.geotools.filter.visitor.CapabilitiesFilterSplitter;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public class CapabilitiesFilterSplitterFunctionTest
extends AbstractCapabilitiesFilterSplitterTests {
    CapabilitiesFilterSplitter visitor;

    @Test
    public void testSupportAll() throws Exception {
        PropertyIsEqualTo filter1 = this.createFunctionFilter();
        FilterFunction_abs filterFunction_abs = new FilterFunction_abs();
        filterFunction_abs.setParameters(Arrays.asList(this.ff.property("name")));
        PropertyIsEqualTo filter2 = this.ff.equals((Expression)this.ff.property("name"), (Expression)filterFunction_abs);
        And filter = this.ff.and((Filter)filter1, (Filter)filter2);
        this.visitor = this.newVisitor(new Capabilities());
        filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPre());
        Assert.assertEquals((Object)filter, (Object)this.visitor.getFilterPost());
        Capabilities filterCapabilitiesMask = new Capabilities();
        filterCapabilitiesMask.addName(this.testFunction.getName());
        filterFunction_abs = new FilterFunction_abs();
        filterCapabilitiesMask.addName(filterFunction_abs.getName());
        filterCapabilitiesMask.addAll(Capabilities.SIMPLE_COMPARISONS_OPENGIS);
        filterCapabilitiesMask.addAll(Capabilities.LOGICAL_OPENGIS);
        this.visitor = this.newVisitor(filterCapabilitiesMask);
        filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)filter, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testSupportOnlySome() throws Exception {
        PropertyIsEqualTo filter1 = this.createFunctionFilter();
        FilterFunction_abs filterFunction_abs = new FilterFunction_abs();
        filterFunction_abs.setParameters(Arrays.asList(this.ff.property("name")));
        PropertyIsEqualTo filter2 = this.ff.equals((Expression)this.ff.property("name"), (Expression)filterFunction_abs);
        And filter = this.ff.and((Filter)filter1, (Filter)filter2);
        Capabilities filterCapabilitiesMask = new Capabilities();
        filterCapabilitiesMask.addName(this.testFunction.getName(), this.testFunction.getParameters().size());
        filterCapabilitiesMask.addAll(Capabilities.SIMPLE_COMPARISONS_OPENGIS);
        filterCapabilitiesMask.addAll(Capabilities.LOGICAL_OPENGIS);
        this.visitor = this.newVisitor(filterCapabilitiesMask);
        filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)filter1, (Object)this.visitor.getFilterPre());
        Assert.assertEquals((Object)filter2, (Object)this.visitor.getFilterPost());
    }
}

