/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilterImpl;
import org.geotools.filter.Expression;
import org.geotools.util.Converters;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsBetween;

public class IsBetweenImpl
extends CompareFilterImpl
implements BetweenFilter {
    private org.opengis.filter.expression.Expression expression;

    protected IsBetweenImpl(FilterFactory factory, org.opengis.filter.expression.Expression lower, org.opengis.filter.expression.Expression expression, org.opengis.filter.expression.Expression upper) {
        super(factory, lower, upper);
        this.expression = expression;
        this.filterType = (short)19;
    }

    public org.opengis.filter.expression.Expression getExpression() {
        return this.expression;
    }

    public void setExpression(org.opengis.filter.expression.Expression expression) {
        this.expression = expression;
    }

    public boolean evaluate(Object feature) {
        Object value = this.eval(this.expression, feature);
        if (value == null) {
            return false;
        }
        Object lower = this.eval(this.getExpression1(), feature);
        Object upper = this.eval(this.getExpression2(), feature);
        Object o = value;
        Object l = Converters.convert(lower, o.getClass());
        Object u = Converters.convert(upper, o.getClass());
        if (l == null || u == null) {
            l = lower;
            o = Converters.convert(value, l.getClass());
            u = Converters.convert(upper, l.getClass());
            if (o == null || u == null) {
                u = upper;
                o = Converters.convert(value, u.getClass());
                l = Converters.convert(lower, u.getClass());
                if (o == null || l == null) {
                    return false;
                }
            }
        }
        Comparable lc = this.comparable(l);
        Comparable uc = this.comparable(u);
        return lc.compareTo(o) <= 0 && uc.compareTo(o) >= 0;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((PropertyIsBetween)this, extraData);
    }

    public org.opengis.filter.expression.Expression getLowerBoundary() {
        return this.getExpression1();
    }

    public void setLowerBoundary(org.opengis.filter.expression.Expression lowerBoundary) {
        this.setExpression1(lowerBoundary);
    }

    public org.opengis.filter.expression.Expression getUpperBoundary() {
        return this.getExpression2();
    }

    public void setUpperBoundary(org.opengis.filter.expression.Expression upperBoundary) {
        this.setExpression2(upperBoundary);
    }

    public final Expression getMiddleValue() {
        return (Expression)this.getExpression();
    }

    public void addMiddleValue(Expression middleValue) {
        this.setExpression((org.opengis.filter.expression.Expression)middleValue);
    }

    public String toString() {
        return "[ " + this.expression + " BETWEEN " + this.expression1 + " AND " + this.expression2 + " ]";
    }
}

