/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.literal;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.geotools.data.Parameter;
import org.geotools.feature.NameImpl;
import org.geotools.process.Process;
import org.geotools.process.impl.SingleProcessFactory;
import org.geotools.process.literal.DoubleAdditionProcess;
import org.geotools.text.Text;
import org.opengis.feature.type.Name;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleAdditionFactory
extends SingleProcessFactory {
    static final Parameter<Double> INPUT_A = new Parameter("input_a", Double.class, Text.text("First value"), Text.text("First value to add"));
    static final Parameter<Double> INPUT_B = new Parameter("input_b", Double.class, Text.text("Second value"), Text.text("Second value to add"));
    static final Parameter<Double> RESULT = new Parameter("result", Double.class, Text.text("Result value"), Text.text("Result of addition"));
    static final Map<String, Parameter<?>> prameterInfo = new TreeMap();
    static final Map<String, Parameter<?>> resultInfo;

    public DoubleAdditionFactory() {
        super((Name)new NameImpl("gt", "DoubleAddition"));
    }

    public Process create(Map<String, Object> parameters) throws IllegalArgumentException {
        return new DoubleAdditionProcess(this);
    }

    @Override
    public InternationalString getDescription() {
        return Text.text("Adds two double precision floating point numbers and returns the sum as a double");
    }

    @Override
    public Map<String, Parameter<?>> getParameterInfo() {
        return Collections.unmodifiableMap(prameterInfo);
    }

    @Override
    public Map<String, Parameter<?>> getResultInfo(Map<String, Object> parameters) throws IllegalArgumentException {
        return Collections.unmodifiableMap(resultInfo);
    }

    @Override
    public InternationalString getTitle() {
        return Text.text("DoubleAddition");
    }

    @Override
    public Process create() throws IllegalArgumentException {
        return new DoubleAdditionProcess(this);
    }

    @Override
    public boolean supportsProgress() {
        return true;
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    static {
        prameterInfo.put(DoubleAdditionFactory.INPUT_A.key, INPUT_A);
        prameterInfo.put(DoubleAdditionFactory.INPUT_B.key, INPUT_B);
        resultInfo = new TreeMap();
        resultInfo.put(DoubleAdditionFactory.RESULT.key, RESULT);
    }
}

