/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.geotools.geometry.AbstractDirectPosition;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Cloneable;

public class DirectPosition2D
extends Point2D.Double
implements DirectPosition,
Serializable,
Cloneable {
    private static final long serialVersionUID = 835130287438466996L;
    private CoordinateReferenceSystem crs;

    public DirectPosition2D() {
    }

    public DirectPosition2D(CoordinateReferenceSystem crs) {
        this.setCoordinateReferenceSystem(crs);
    }

    public DirectPosition2D(double x, double y) {
        super(x, y);
    }

    public DirectPosition2D(CoordinateReferenceSystem crs, double x, double y) {
        super(x, y);
        this.setCoordinateReferenceSystem(crs);
    }

    public DirectPosition2D(Point2D point) {
        super(point.getX(), point.getY());
        if (point instanceof DirectPosition) {
            this.setCoordinateReferenceSystem(((DirectPosition)point).getCoordinateReferenceSystem());
        }
    }

    public DirectPosition2D(DirectPosition point) {
        this.setLocation(point);
    }

    @Deprecated
    public DirectPosition getPosition() {
        return this;
    }

    public DirectPosition getDirectPosition() {
        return this;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(crs, 2);
        this.crs = crs;
    }

    public final int getDimension() {
        return 2;
    }

    public double[] getCoordinate() {
        return new double[]{this.x, this.y};
    }

    @Deprecated
    public double[] getCoordinates() {
        return this.getCoordinate();
    }

    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public final void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(String.valueOf(dimension));
            }
        }
    }

    public void setLocation(DirectPosition position) throws MismatchedDimensionException {
        AbstractDirectPosition.ensureDimensionMatch("position", position.getDimension(), 2);
        this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
        this.x = position.getOrdinate(0);
        this.y = position.getOrdinate(1);
    }

    public Point2D toPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }

    public String toString() {
        return AbstractDirectPosition.toString(this);
    }

    public int hashCode() {
        return AbstractDirectPosition.hashCode(this);
    }

    public boolean equals(Object object) {
        if (object instanceof DirectPosition) {
            DirectPosition other = (DirectPosition)object;
            if (other.getDimension() == 2 && Utilities.equals((double)other.getOrdinate(0), (double)this.x) && Utilities.equals((double)other.getOrdinate(1), (double)this.y) && Utilities.equals((Object)other.getCoordinateReferenceSystem(), (Object)this.crs)) {
                assert (this.hashCode() == other.hashCode()) : this;
                return true;
            }
            return false;
        }
        return super.equals(object);
    }

    public DirectPosition2D clone() {
        return (DirectPosition2D)super.clone();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeDouble(this.x);
        out.writeDouble(this.y);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.x = in.readDouble();
        this.y = in.readDouble();
    }
}

