/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import com.vividsolutions.jts.geom.Geometry;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.swing.JTextReporter;
import org.geotools.swing.TextReporterListener;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.tool.CursorTool;
import org.geotools.swing.tool.InfoToolHelper;
import org.geotools.swing.tool.VectorLayerHelper;
import org.geotools.swing.utils.MapLayerUtils;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoTool
extends CursorTool
implements TextReporterListener {
    private static final ResourceBundle stringRes = ResourceBundle.getBundle("org/geotools/swing/Text");
    public static final String TOOL_NAME = stringRes.getString("tool_name_info");
    public static final String TOOL_TIP = stringRes.getString("tool_tip_info");
    public static final String CURSOR_IMAGE = "/org/geotools/swing/icons/mActionIdentify.png";
    public static final Point CURSOR_HOTSPOT = new Point(0, 0);
    public static final String ICON_IMAGE = "/org/geotools/swing/icons/mActionIdentify.png";
    public static final double DEFAULT_DISTANCE_FRACTION = 0.01;
    private Cursor cursor;
    private JTextReporter reporter;
    private WeakHashMap<MapLayer, InfoToolHelper> helperTable;

    public InfoTool() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        ImageIcon cursorIcon = new ImageIcon(this.getClass().getResource("/org/geotools/swing/icons/mActionIdentify.png"));
        int iconWidth = cursorIcon.getIconWidth();
        int iconHeight = cursorIcon.getIconHeight();
        Dimension bestCursorSize = tk.getBestCursorSize(cursorIcon.getIconWidth(), cursorIcon.getIconHeight());
        this.cursor = tk.createCustomCursor(cursorIcon.getImage(), CURSOR_HOTSPOT, TOOL_TIP);
        this.helperTable = new WeakHashMap();
    }

    @Override
    public void onMouseClicked(MapMouseEvent ev) {
        DirectPosition2D pos = ev.getMapPosition();
        this.report(pos);
        MapContext context = this.getMapPane().getMapContext();
        for (MapLayer layer : context.getLayers()) {
            List bandValues;
            if (!layer.isSelected()) continue;
            InfoToolHelper helper = null;
            String layerName = layer.getTitle();
            if (layerName == null || layerName.length() == 0) {
                layerName = layer.getFeatureSource().getName().getLocalPart();
            }
            if (layerName == null || layerName.length() == 0) {
                layerName = layer.getFeatureSource().getSchema().getName().getLocalPart();
            }
            if ((helper = this.helperTable.get(layer)) == null) {
                Constructor<?> ctor;
                Class<?> clazz;
                if (MapLayerUtils.isGridLayer(layer)) {
                    try {
                        clazz = Class.forName("org.geotools.swing.tool.GridLayerHelper");
                        ctor = clazz.getConstructor(MapContext.class, MapLayer.class);
                        helper = (InfoToolHelper)ctor.newInstance(context, layer);
                        this.helperTable.put(layer, helper);
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Failed to create InfoToolHelper for grid layer", ex);
                    }
                }
                try {
                    clazz = Class.forName("org.geotools.swing.tool.VectorLayerHelper");
                    ctor = clazz.getConstructor(MapContext.class, MapLayer.class);
                    helper = (InfoToolHelper)ctor.newInstance(context, layer);
                    this.helperTable.put(layer, helper);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to create InfoToolHelper for vector layer", ex);
                }
            }
            Object info = null;
            if (helper instanceof VectorLayerHelper) {
                ReferencedEnvelope mapEnv = this.getMapPane().getDisplayArea();
                double searchWidth = 0.01 * (mapEnv.getWidth() + mapEnv.getHeight()) / 2.0;
                try {
                    info = helper.getInfo(pos, searchWidth);
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
                if (info == null) continue;
                FeatureIterator iter = null;
                FeatureCollection selectedFeatures = info;
                try {
                    iter = selectedFeatures.features();
                    while (iter.hasNext()) {
                        this.report(layerName, iter.next());
                    }
                    continue;
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
                finally {
                    if (iter != null) {
                        iter.close();
                    }
                }
            }
            try {
                info = helper.getInfo(pos, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
            if (info == null || (bandValues = (List)info).isEmpty()) continue;
            this.report(layerName, bandValues);
        }
    }

    private void report(DirectPosition2D pos) {
        this.createReporter();
        this.reporter.append(String.format("Pos x=%.4f y=%.4f\n\n", pos.x, pos.y));
    }

    private void report(String layerName, Feature feature) {
        this.createReporter();
        Collection props = feature.getProperties();
        String valueStr = null;
        this.reporter.append(layerName);
        this.reporter.append("\n");
        for (Property prop : props) {
            String name = prop.getName().getLocalPart();
            Object value = prop.getValue();
            if (value != null) {
                if (value instanceof Geometry) {
                    name = "  Geometry";
                    valueStr = value.getClass().getSimpleName();
                } else {
                    valueStr = value.toString();
                }
            } else {
                valueStr = "null";
            }
            this.reporter.append(name + ": " + valueStr);
            this.reporter.append("\n");
        }
        this.reporter.append("\n");
    }

    private void report(String layerName, List<Number> bandValues) {
        this.createReporter();
        this.reporter.append(layerName);
        this.reporter.append("\n");
        int k = 1;
        for (Number value : bandValues) {
            this.reporter.append(String.format("  Band %d: %s\n", k++, value.toString()));
        }
        this.reporter.append("\n");
    }

    private void createReporter() {
        if (this.reporter == null) {
            this.reporter = new JTextReporter("Feature info", 20, 30);
            this.reporter.addListener(this);
            this.reporter.setVisible(true);
        }
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public boolean drawDragBox() {
        return false;
    }

    @Override
    public void onReporterClosed(WindowEvent ev) {
        this.reporter = null;
    }

    @Override
    public void onReporterUpdated(int newTextStartLine) {
    }
}

