/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.extractor.builtin.impl;

import java.util.Iterator;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractionContext;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractor;
import org.hibernate.search.mapper.pojo.extractor.ValueProcessor;

abstract class AbstractIteratorBasedElementExtractor<C, T>
implements ContainerExtractor<C, T> {
    AbstractIteratorBasedElementExtractor() {
    }

    @Override
    public <T1, C2> void extract(C container, ValueProcessor<T1, ? super T, C2> perValueProcessor, T1 target, C2 context, ContainerExtractionContext extractionContext) {
        Iterator<T> iterator;
        if (container == null) {
            return;
        }
        try {
            iterator = this.iterator(container);
        }
        catch (RuntimeException e) {
            extractionContext.propagateOrIgnoreContainerExtractionException(e);
            return;
        }
        while (iterator.hasNext()) {
            T element;
            try {
                element = iterator.next();
            }
            catch (RuntimeException e) {
                extractionContext.propagateOrIgnoreContainerExtractionException(e);
                return;
            }
            perValueProcessor.process(target, element, context, extractionContext);
        }
    }

    protected abstract Iterator<T> iterator(C var1);
}

