/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.AuthenticatedData;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAuthenticatedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import org.bouncycastle.cms.IntRecipientInfoGenerator;
import org.bouncycastle.cms.MacOutputStream;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.MacCalculator;
import org.bouncycastle.util.io.TeeOutputStream;

public class CMSAuthenticatedDataStreamGenerator
extends CMSAuthenticatedGenerator {
    private int bufferSize;
    private boolean berEncodeRecipientSet;
    private MacCalculator macCalculator;

    public CMSAuthenticatedDataStreamGenerator() {
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setBEREncodeRecipients(boolean useBerEncodingForRecipients) {
        this.berEncodeRecipientSet = useBerEncodingForRecipients;
    }

    public OutputStream open(OutputStream out, MacCalculator macCalculator) throws CMSException {
        return this.open(CMSObjectIdentifiers.data, out, macCalculator);
    }

    public OutputStream open(OutputStream out, MacCalculator macCalculator, DigestCalculator digestCalculator) throws CMSException {
        return this.open(CMSObjectIdentifiers.data, out, macCalculator, digestCalculator);
    }

    public OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out, MacCalculator macCalculator) throws CMSException {
        return this.open(dataType, out, macCalculator, null);
    }

    public OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out, MacCalculator macCalculator, DigestCalculator digestCalculator) throws CMSException {
        this.macCalculator = macCalculator;
        try {
            ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
            for (RecipientInfoGenerator recipient : this.recipientInfoGenerators) {
                recipientInfos.add((DEREncodable)recipient.generate(macCalculator.getKey()));
            }
            BERSequenceGenerator cGen = new BERSequenceGenerator(out);
            cGen.addObject((DEREncodable)CMSObjectIdentifiers.authenticatedData);
            BERSequenceGenerator authGen = new BERSequenceGenerator(cGen.getRawOutputStream(), 0, true);
            authGen.addObject((DEREncodable)new DERInteger(AuthenticatedData.calculateVersion(null)));
            if (this.berEncodeRecipientSet) {
                authGen.getRawOutputStream().write(new BERSet(recipientInfos).getEncoded());
            } else {
                authGen.getRawOutputStream().write(new DERSet(recipientInfos).getEncoded());
            }
            AlgorithmIdentifier macAlgId = macCalculator.getAlgorithmIdentifier();
            authGen.getRawOutputStream().write(macAlgId.getEncoded());
            if (digestCalculator != null) {
                authGen.addObject((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)digestCalculator.getAlgorithmIdentifier()));
            }
            BERSequenceGenerator eiGen = new BERSequenceGenerator(authGen.getRawOutputStream());
            eiGen.addObject((DEREncodable)dataType);
            OutputStream octetStream = CMSUtils.createBEROctetOutputStream(eiGen.getRawOutputStream(), 0, false, this.bufferSize);
            TeeOutputStream mOut = digestCalculator != null ? new TeeOutputStream(octetStream, digestCalculator.getOutputStream()) : new TeeOutputStream(octetStream, macCalculator.getOutputStream());
            return new CmsAuthenticatedDataOutputStream(macCalculator, digestCalculator, dataType, (OutputStream)mOut, cGen, authGen, eiGen);
        }
        catch (IOException e) {
            throw new CMSException("exception decoding algorithm parameters.", e);
        }
    }

    public CMSAuthenticatedDataStreamGenerator(SecureRandom rand) {
        super(rand);
    }

    private OutputStream open(OutputStream out, String macOID, KeyGenerator keyGen, Provider provider) throws NoSuchAlgorithmException, CMSException {
        Provider encProvider = keyGen.getProvider();
        SecretKey encKey = keyGen.generateKey();
        AlgorithmParameterSpec params = this.generateParameterSpec(macOID, encKey, encProvider);
        Iterator it = this.oldRecipientInfoGenerators.iterator();
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        while (it.hasNext()) {
            Object recipient = (IntRecipientInfoGenerator)it.next();
            try {
                recipientInfos.add((DEREncodable)recipient.generate(encKey, this.rand, provider));
            }
            catch (InvalidKeyException e) {
                throw new CMSException("key inappropriate for algorithm.", e);
            }
            catch (GeneralSecurityException e) {
                throw new CMSException("error making encrypted content.", e);
            }
        }
        for (Object recipient : this.recipientInfoGenerators) {
            recipientInfos.add((DEREncodable)recipient.generate(new GenericKey(encKey)));
        }
        return this.open(out, macOID, encKey, params, recipientInfos, encProvider);
    }

    protected OutputStream open(OutputStream out, String macOID, SecretKey encKey, AlgorithmParameterSpec params, ASN1EncodableVector recipientInfos, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.open(out, macOID, encKey, params, recipientInfos, CMSUtils.getProvider(provider));
    }

    protected OutputStream open(OutputStream out, String macOID, SecretKey encKey, AlgorithmParameterSpec params, ASN1EncodableVector recipientInfos, Provider provider) throws NoSuchAlgorithmException, CMSException {
        try {
            BERSequenceGenerator cGen = new BERSequenceGenerator(out);
            cGen.addObject((DEREncodable)CMSObjectIdentifiers.authenticatedData);
            BERSequenceGenerator authGen = new BERSequenceGenerator(cGen.getRawOutputStream(), 0, true);
            authGen.addObject((DEREncodable)new DERInteger(AuthenticatedData.calculateVersion(null)));
            if (this.berEncodeRecipientSet) {
                authGen.getRawOutputStream().write(new BERSet(recipientInfos).getEncoded());
            } else {
                authGen.getRawOutputStream().write(new DERSet(recipientInfos).getEncoded());
            }
            Mac mac = CMSEnvelopedHelper.INSTANCE.getMac(macOID, provider);
            mac.init(encKey, params);
            AlgorithmIdentifier macAlgId = this.getAlgorithmIdentifier(macOID, params, provider);
            authGen.getRawOutputStream().write(macAlgId.getEncoded());
            BERSequenceGenerator eiGen = new BERSequenceGenerator(authGen.getRawOutputStream());
            eiGen.addObject((DEREncodable)CMSObjectIdentifiers.data);
            OutputStream octetStream = CMSUtils.createBEROctetOutputStream(eiGen.getRawOutputStream(), 0, false, this.bufferSize);
            TeeOutputStream mOut = new TeeOutputStream(octetStream, (OutputStream)new MacOutputStream(mac));
            return new OldCmsAuthenticatedDataOutputStream((OutputStream)mOut, mac, cGen, authGen, eiGen);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException("algorithm parameter invalid.", e);
        }
        catch (InvalidParameterSpecException e) {
            throw new CMSException("algorithm parameter spec invalid.", e);
        }
        catch (IOException e) {
            throw new CMSException("exception decoding algorithm parameters.", e);
        }
    }

    public OutputStream open(OutputStream out, String encryptionOID, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        return this.open(out, encryptionOID, CMSUtils.getProvider(provider));
    }

    public OutputStream open(OutputStream out, String encryptionOID, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
        keyGen.init(this.rand);
        return this.open(out, encryptionOID, keyGen, provider);
    }

    public OutputStream open(OutputStream out, String encryptionOID, int keySize, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        return this.open(out, encryptionOID, keySize, CMSUtils.getProvider(provider));
    }

    public OutputStream open(OutputStream out, String encryptionOID, int keySize, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
        keyGen.init(keySize, this.rand);
        return this.open(out, encryptionOID, keyGen, provider);
    }

    private class OldCmsAuthenticatedDataOutputStream
    extends OutputStream {
        private OutputStream dataStream;
        private Mac mac;
        private BERSequenceGenerator cGen;
        private BERSequenceGenerator envGen;
        private BERSequenceGenerator eiGen;

        public OldCmsAuthenticatedDataOutputStream(OutputStream dataStream, Mac mac, BERSequenceGenerator cGen, BERSequenceGenerator envGen, BERSequenceGenerator eiGen) {
            this.dataStream = dataStream;
            this.mac = mac;
            this.cGen = cGen;
            this.envGen = envGen;
            this.eiGen = eiGen;
        }

        public void write(int b) throws IOException {
            this.dataStream.write(b);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this.dataStream.write(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this.dataStream.write(bytes);
        }

        public void close() throws IOException {
            this.dataStream.close();
            this.eiGen.close();
            this.envGen.addObject((DEREncodable)new DEROctetString(this.mac.doFinal()));
            this.envGen.close();
            this.cGen.close();
        }
    }

    private class CmsAuthenticatedDataOutputStream
    extends OutputStream {
        private OutputStream dataStream;
        private BERSequenceGenerator cGen;
        private BERSequenceGenerator envGen;
        private BERSequenceGenerator eiGen;
        private MacCalculator macCalculator;
        private DigestCalculator digestCalculator;
        private ASN1ObjectIdentifier contentType;

        public CmsAuthenticatedDataOutputStream(MacCalculator macCalculator, DigestCalculator digestCalculator, ASN1ObjectIdentifier contentType, OutputStream dataStream, BERSequenceGenerator cGen, BERSequenceGenerator envGen, BERSequenceGenerator eiGen) {
            this.macCalculator = macCalculator;
            this.digestCalculator = digestCalculator;
            this.contentType = contentType;
            this.dataStream = dataStream;
            this.cGen = cGen;
            this.envGen = envGen;
            this.eiGen = eiGen;
        }

        public void write(int b) throws IOException {
            this.dataStream.write(b);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this.dataStream.write(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this.dataStream.write(bytes);
        }

        public void close() throws IOException {
            Map parameters;
            this.dataStream.close();
            this.eiGen.close();
            if (this.digestCalculator != null) {
                parameters = Collections.unmodifiableMap(CMSAuthenticatedDataStreamGenerator.this.getBaseParameters((DERObjectIdentifier)this.contentType, this.digestCalculator.getAlgorithmIdentifier(), this.digestCalculator.getDigest()));
                if (CMSAuthenticatedDataStreamGenerator.this.authGen == null) {
                    CMSAuthenticatedDataStreamGenerator.this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
                }
                DERSet authed = new DERSet(CMSAuthenticatedDataStreamGenerator.this.authGen.getAttributes(parameters).toASN1EncodableVector());
                OutputStream mOut = this.macCalculator.getOutputStream();
                mOut.write(authed.getDEREncoded());
                mOut.close();
                this.envGen.addObject((DEREncodable)new DERTaggedObject(false, 2, (DEREncodable)authed));
            } else {
                parameters = Collections.unmodifiableMap(new HashMap());
            }
            this.envGen.addObject((DEREncodable)new DEROctetString(this.macCalculator.getMac()));
            if (CMSAuthenticatedDataStreamGenerator.this.unauthGen != null) {
                this.envGen.addObject((DEREncodable)new DERTaggedObject(false, 3, (DEREncodable)new BERSet(CMSAuthenticatedDataStreamGenerator.this.unauthGen.getAttributes(parameters).toASN1EncodableVector())));
            }
            this.envGen.close();
            this.cGen.close();
        }
    }
}

