/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSPBEKey;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.KEKIntRecipientInfoGenerator;
import org.bouncycastle.cms.KeyAgreeIntRecipientInfoGenerator;
import org.bouncycastle.cms.KeyTransIntRecipientInfoGenerator;
import org.bouncycastle.cms.PasswordIntRecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInfoGenerator;

public class CMSEnvelopedGenerator {
    public static final String DES_EDE3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC.getId();
    public static final String RC2_CBC = PKCSObjectIdentifiers.RC2_CBC.getId();
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = NISTObjectIdentifiers.id_aes128_CBC.getId();
    public static final String AES192_CBC = NISTObjectIdentifiers.id_aes192_CBC.getId();
    public static final String AES256_CBC = NISTObjectIdentifiers.id_aes256_CBC.getId();
    public static final String CAMELLIA128_CBC = NTTObjectIdentifiers.id_camellia128_cbc.getId();
    public static final String CAMELLIA192_CBC = NTTObjectIdentifiers.id_camellia192_cbc.getId();
    public static final String CAMELLIA256_CBC = NTTObjectIdentifiers.id_camellia256_cbc.getId();
    public static final String SEED_CBC = KISAObjectIdentifiers.id_seedCBC.getId();
    public static final String DES_EDE3_WRAP = PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId();
    public static final String AES128_WRAP = NISTObjectIdentifiers.id_aes128_wrap.getId();
    public static final String AES192_WRAP = NISTObjectIdentifiers.id_aes192_wrap.getId();
    public static final String AES256_WRAP = NISTObjectIdentifiers.id_aes256_wrap.getId();
    public static final String CAMELLIA128_WRAP = NTTObjectIdentifiers.id_camellia128_wrap.getId();
    public static final String CAMELLIA192_WRAP = NTTObjectIdentifiers.id_camellia192_wrap.getId();
    public static final String CAMELLIA256_WRAP = NTTObjectIdentifiers.id_camellia256_wrap.getId();
    public static final String SEED_WRAP = KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap.getId();
    public static final String ECDH_SHA1KDF = X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme.getId();
    public static final String ECMQV_SHA1KDF = X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme.getId();
    final List oldRecipientInfoGenerators = new ArrayList();
    final List recipientInfoGenerators = new ArrayList();
    protected CMSAttributeTableGenerator unprotectedAttributeGenerator = null;
    final SecureRandom rand;

    public CMSEnvelopedGenerator() {
        this(new SecureRandom());
    }

    public CMSEnvelopedGenerator(SecureRandom rand) {
        this.rand = rand;
    }

    public void setUnprotectedAttributeGenerator(CMSAttributeTableGenerator unprotectedAttributeGenerator) {
        this.unprotectedAttributeGenerator = unprotectedAttributeGenerator;
    }

    public void addKeyTransRecipient(X509Certificate cert) throws IllegalArgumentException {
        KeyTransIntRecipientInfoGenerator ktrig = new KeyTransIntRecipientInfoGenerator();
        ktrig.setRecipientCert(cert);
        this.oldRecipientInfoGenerators.add(ktrig);
    }

    public void addKeyTransRecipient(PublicKey key, byte[] subKeyId) throws IllegalArgumentException {
        KeyTransIntRecipientInfoGenerator ktrig = new KeyTransIntRecipientInfoGenerator();
        ktrig.setRecipientPublicKey(key);
        ktrig.setSubjectKeyIdentifier((ASN1OctetString)new DEROctetString(subKeyId));
        this.oldRecipientInfoGenerators.add(ktrig);
    }

    public void addKEKRecipient(SecretKey key, byte[] keyIdentifier) {
        this.addKEKRecipient(key, new KEKIdentifier(keyIdentifier, null, null));
    }

    public void addKEKRecipient(SecretKey key, KEKIdentifier kekIdentifier) {
        KEKIntRecipientInfoGenerator kekrig = new KEKIntRecipientInfoGenerator();
        kekrig.setKEKIdentifier(kekIdentifier);
        kekrig.setKeyEncryptionKey(key);
        this.oldRecipientInfoGenerators.add(kekrig);
    }

    public void addPasswordRecipient(CMSPBEKey pbeKey, String kekAlgorithmOid) {
        PBKDF2Params params = new PBKDF2Params(pbeKey.getSalt(), pbeKey.getIterationCount());
        PasswordIntRecipientInfoGenerator prig = new PasswordIntRecipientInfoGenerator();
        prig.setKeyDerivationAlgorithm(new AlgorithmIdentifier((DERObjectIdentifier)PKCSObjectIdentifiers.id_PBKDF2, (DEREncodable)params));
        prig.setKeyEncryptionKey(new SecretKeySpec(pbeKey.getEncoded(kekAlgorithmOid), kekAlgorithmOid));
        this.oldRecipientInfoGenerators.add(prig);
    }

    public void addKeyAgreementRecipient(String agreementAlgorithm, PrivateKey senderPrivateKey, PublicKey senderPublicKey, X509Certificate recipientCert, String cekWrapAlgorithm, String provider) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this.addKeyAgreementRecipient(agreementAlgorithm, senderPrivateKey, senderPublicKey, recipientCert, cekWrapAlgorithm, CMSUtils.getProvider(provider));
    }

    public void addKeyAgreementRecipient(String agreementAlgorithm, PrivateKey senderPrivateKey, PublicKey senderPublicKey, X509Certificate recipientCert, String cekWrapAlgorithm, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addKeyAgreementRecipients(agreementAlgorithm, senderPrivateKey, senderPublicKey, Collections.singletonList(recipientCert), cekWrapAlgorithm, provider);
    }

    public void addKeyAgreementRecipients(String agreementAlgorithm, PrivateKey senderPrivateKey, PublicKey senderPublicKey, Collection recipientCerts, String cekWrapAlgorithm, String provider) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this.addKeyAgreementRecipients(agreementAlgorithm, senderPrivateKey, senderPublicKey, recipientCerts, cekWrapAlgorithm, CMSUtils.getProvider(provider));
    }

    public void addKeyAgreementRecipients(String agreementAlgorithm, PrivateKey senderPrivateKey, PublicKey senderPublicKey, Collection recipientCerts, String cekWrapAlgorithm, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        KeyAgreeIntRecipientInfoGenerator karig = new KeyAgreeIntRecipientInfoGenerator();
        karig.setKeyAgreementOID(new DERObjectIdentifier(agreementAlgorithm));
        karig.setKeyEncryptionOID(new DERObjectIdentifier(cekWrapAlgorithm));
        karig.setRecipientCerts(recipientCerts);
        karig.setSenderKeyPair(new KeyPair(senderPublicKey, senderPrivateKey));
        this.oldRecipientInfoGenerators.add(karig);
    }

    public void addRecipientInfoGenerator(RecipientInfoGenerator recipientGenerator) {
        this.recipientInfoGenerators.add(recipientGenerator);
    }

    protected AlgorithmIdentifier getAlgorithmIdentifier(String encryptionOID, AlgorithmParameters params) throws IOException {
        Object asn1Params = params != null ? ASN1Object.fromByteArray((byte[])params.getEncoded("ASN.1")) : DERNull.INSTANCE;
        return new AlgorithmIdentifier(new DERObjectIdentifier(encryptionOID), (DEREncodable)asn1Params);
    }

    protected AlgorithmParameters generateParameters(String encryptionOID, SecretKey encKey, Provider encProvider) throws CMSException {
        try {
            AlgorithmParameterGenerator pGen = AlgorithmParameterGenerator.getInstance(encryptionOID, encProvider);
            if (encryptionOID.equals(RC2_CBC)) {
                byte[] iv = new byte[8];
                this.rand.nextBytes(iv);
                try {
                    pGen.init(new RC2ParameterSpec(encKey.getEncoded().length * 8, iv), this.rand);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new CMSException("parameters generation error: " + e, e);
                }
            }
            return pGen.generateParameters();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }
}

