/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.test.CMSTestSetup;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509CollectionStoreParameters;
import org.bouncycastle.x509.X509Store;
import org.bouncycastle.x509.X509StoreParameters;

public class SignedDataStreamTest
extends TestCase {
    private static final String BC = BouncyCastleProvider.PROVIDER_NAME;
    private static final String TEST_MESSAGE = "Hello World!";
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static String _reciDN;
    private static KeyPair _reciKP;
    private static X509Certificate _reciCert;
    private static KeyPair _origDsaKP;
    private static X509Certificate _origDsaCert;
    private static X509CRL _signCrl;
    private static X509CRL _origCrl;
    private static boolean _initialised;

    public SignedDataStreamTest(String name) {
        super(name);
    }

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            _signDN = "O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _signKP, _signDN);
            _origDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _signKP, _signDN);
            _origDsaKP = CMSTestUtil.makeDsaKeyPair();
            _origDsaCert = CMSTestUtil.makeCertificate(_origDsaKP, _origDN, _signKP, _signDN);
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
            _signCrl = CMSTestUtil.makeCrl(_signKP);
            _origCrl = CMSTestUtil.makeCrl(_origKP);
        }
    }

    private void verifySignatures(CMSSignedDataParser sp, byte[] contentDigest) throws Exception {
        CertStore certStore = sp.getCertificatesAndCRLs("Collection", BC);
        SignerInformationStore signers = sp.getSignerInfos();
        Collection c = signers.getSigners();
        for (SignerInformation signer : c) {
            Collection<? extends Certificate> certCollection = certStore.getCertificates(signer.getSID());
            Iterator<? extends Certificate> certIt = certCollection.iterator();
            X509Certificate cert = (X509Certificate)certIt.next();
            SignedDataStreamTest.assertEquals((boolean)true, (boolean)signer.verify(cert, BC));
            if (contentDigest == null) continue;
            SignedDataStreamTest.assertTrue((boolean)MessageDigest.isEqual(contentDigest, signer.getContentDigest()));
        }
        Collection<? extends Certificate> certColl = certStore.getCertificates(null);
        Collection<? extends CRL> crlColl = certStore.getCRLs(null);
        SignedDataStreamTest.assertEquals((int)certColl.size(), (int)sp.getCertificates("Collection", BC).getMatches(null).size());
        SignedDataStreamTest.assertEquals((int)crlColl.size(), (int)sp.getCRLs("Collection", BC).getMatches(null).size());
    }

    private void verifySignatures(CMSSignedDataParser sp) throws Exception {
        this.verifySignatures(sp, null);
    }

    private void verifyEncodedData(ByteArrayOutputStream bOut) throws Exception {
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
        sp.close();
    }

    private void checkSigParseable(byte[] sig) throws Exception {
        CMSSignedDataParser sp = new CMSSignedDataParser(sig);
        sp.getVersion();
        CMSTypedStream sc = sp.getSignedContent();
        if (sc != null) {
            sc.drain();
        }
        sp.getCertificatesAndCRLs("Collection", BC);
        sp.getSignerInfos();
        sp.close();
    }

    public void testEarlyInvalidKeyException() throws Exception {
        try {
            CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
            gen.addSigner(_origKP.getPrivate(), _origCert, "DSA", CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
            SignedDataStreamTest.fail((String)"Expected InvalidKeyException in addSigner");
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
    }

    public void testEarlyNoSuchAlgorithmException() throws Exception {
        try {
            CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
            gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
            SignedDataStreamTest.fail((String)"Expected NoSuchAlgorithmException in addSigner");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public void testSha1EncapsulatedSignature() throws Exception {
        byte[] encapSigData = Base64.decode((String)"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");
        CMSSignedDataParser sp = new CMSSignedDataParser(encapSigData);
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
    }

    public void testSHA1WithRSANoAttributes() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray(TEST_MESSAGE.getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataGenerator.DIGEST_SHA1);
        gen.addCertificatesAndCRLs(certs);
        CMSSignedData s = gen.generate(CMSSignedDataGenerator.DATA, (CMSProcessable)msg, false, BC, false);
        CMSSignedDataParser sp = new CMSSignedDataParser(new CMSTypedStream(new ByteArrayInputStream(TEST_MESSAGE.getBytes())), s.getEncoded());
        sp.getSignedContent().drain();
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(sp, md.digest(TEST_MESSAGE.getBytes()));
    }

    public void testDSANoAttributes() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray(TEST_MESSAGE.getBytes());
        certList.add(_origDsaCert);
        certList.add(_signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        gen.addSigner(_origDsaKP.getPrivate(), _origDsaCert, CMSSignedDataGenerator.DIGEST_SHA1);
        gen.addCertificatesAndCRLs(certs);
        CMSSignedData s = gen.generate(CMSSignedDataGenerator.DATA, (CMSProcessable)msg, false, BC, false);
        CMSSignedDataParser sp = new CMSSignedDataParser(new CMSTypedStream(new ByteArrayInputStream(TEST_MESSAGE.getBytes())), s.getEncoded());
        sp.getSignedContent().drain();
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(sp, md.digest(TEST_MESSAGE.getBytes()));
    }

    public void testSHA1WithRSA() throws Exception {
        ArrayList<X509Extension> certList = new ArrayList<X509Extension>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        certList.add(_signCrl);
        certList.add(_origCrl);
        CertStore certsAndCrls = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certsAndCrls);
        OutputStream sigOut = gen.open(bOut);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        this.checkSigParseable(bOut.toByteArray());
        CMSSignedDataParser sp = new CMSSignedDataParser(new CMSTypedStream(new ByteArrayInputStream(TEST_MESSAGE.getBytes())), bOut.toByteArray());
        sp.getSignedContent().drain();
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(sp, md.digest(TEST_MESSAGE.getBytes()));
        gen = new CMSSignedDataStreamGenerator();
        gen.addSigners(sp.getSignerInfos());
        gen.addCertificatesAndCRLs(sp.getCertificatesAndCRLs("Collection", BC));
        bOut.reset();
        sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        this.verifyEncodedData(bOut);
        Collection<? extends CRL> col = certsAndCrls.getCRLs(null);
        SignedDataStreamTest.assertEquals((int)2, (int)col.size());
        SignedDataStreamTest.assertTrue((boolean)col.contains(_signCrl));
        SignedDataStreamTest.assertTrue((boolean)col.contains(_origCrl));
    }

    public void testSHA1WithRSANonData() throws Exception {
        ArrayList<X509Extension> certList = new ArrayList<X509Extension>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        certList.add(_signCrl);
        certList.add(_origCrl);
        CertStore certsAndCrls = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certsAndCrls);
        OutputStream sigOut = gen.open((OutputStream)bOut, "1.2.3.4", true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        CMSTypedStream stream = sp.getSignedContent();
        SignedDataStreamTest.assertEquals((Object)new ASN1ObjectIdentifier("1.2.3.4"), (Object)stream.getContentType());
        stream.drain();
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(sp, md.digest(TEST_MESSAGE.getBytes()));
    }

    public void testSHA1AndMD5WithRSA() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_MD5, BC);
        gen.addCertificatesAndCRLs(certs);
        OutputStream sigOut = gen.open(bOut);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        this.checkSigParseable(bOut.toByteArray());
        CMSSignedDataParser sp = new CMSSignedDataParser(new CMSTypedStream(new ByteArrayInputStream(TEST_MESSAGE.getBytes())), bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
    }

    public void testSHA1WithRSAEncapsulatedBufferedStream() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certs);
        OutputStream sigOut = gen.open(bOut, true);
        for (int i = 0; i != 2000; ++i) {
            sigOut.write(i & 0xFF);
        }
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
        int unbufferedLength = bOut.toByteArray().length;
        bOut = new ByteArrayOutputStream();
        gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certs);
        sigOut = gen.open(bOut, true);
        BufferedOutputStream bfOut = new BufferedOutputStream(sigOut, 300);
        for (int i = 0; i != 2000; ++i) {
            bfOut.write(i & 0xFF);
        }
        bfOut.close();
        this.verifyEncodedData(bOut);
        SignedDataStreamTest.assertTrue((bOut.toByteArray().length == unbufferedLength ? 1 : 0) != 0);
    }

    public void testSHA1WithRSAEncapsulatedBuffered() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certs);
        OutputStream sigOut = gen.open(bOut, true);
        for (int i = 0; i != 2000; ++i) {
            sigOut.write(i & 0xFF);
        }
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
        int unbufferedLength = bOut.toByteArray().length;
        bOut = new ByteArrayOutputStream();
        gen = new CMSSignedDataStreamGenerator();
        gen.setBufferSize(300);
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certs);
        sigOut = gen.open(bOut, true);
        for (int i = 0; i != 2000; ++i) {
            sigOut.write(i & 0xFF);
        }
        sigOut.close();
        this.verifyEncodedData(bOut);
        SignedDataStreamTest.assertTrue((bOut.toByteArray().length > unbufferedLength ? 1 : 0) != 0);
    }

    public void testSHA1WithRSAEncapsulated() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certs);
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
        byte[] contentDigest = (byte[])gen.getGeneratedDigests().get(CMSSignedGenerator.DIGEST_SHA1);
        AttributeTable table = ((SignerInformation)sp.getSignerInfos().getSigners().iterator().next()).getSignedAttributes();
        Attribute hash = table.get((DERObjectIdentifier)CMSAttributes.messageDigest);
        SignedDataStreamTest.assertTrue((boolean)MessageDigest.isEqual(contentDigest, ((ASN1OctetString)hash.getAttrValues().getObjectAt(0)).getOctets()));
        gen = new CMSSignedDataStreamGenerator();
        gen.addSigners(sp.getSignerInfos());
        gen.addCertificatesAndCRLs(sp.getCertificatesAndCRLs("Collection", BC));
        bOut.reset();
        sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedData sd = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(TEST_MESSAGE.getBytes()), bOut.toByteArray());
        SignedDataStreamTest.assertEquals((int)1, (int)sd.getSignerInfos().getSigners().size());
        this.verifyEncodedData(bOut);
    }

    public void testSHA1WithRSAEncapsulatedSubjectKeyID() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), CMSTestUtil.createSubjectKeyId(_origCert.getPublicKey()).getKeyIdentifier(), CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certs);
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
        byte[] contentDigest = (byte[])gen.getGeneratedDigests().get(CMSSignedGenerator.DIGEST_SHA1);
        AttributeTable table = ((SignerInformation)sp.getSignerInfos().getSigners().iterator().next()).getSignedAttributes();
        Attribute hash = table.get((DERObjectIdentifier)CMSAttributes.messageDigest);
        SignedDataStreamTest.assertTrue((boolean)MessageDigest.isEqual(contentDigest, ((ASN1OctetString)hash.getAttrValues().getObjectAt(0)).getOctets()));
        gen = new CMSSignedDataStreamGenerator();
        gen.addSigners(sp.getSignerInfos());
        gen.addCertificatesAndCRLs(sp.getCertificatesAndCRLs("Collection", BC));
        bOut.reset();
        sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedData sd = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(TEST_MESSAGE.getBytes()), bOut.toByteArray());
        SignedDataStreamTest.assertEquals((int)1, (int)sd.getSignerInfos().getSigners().size());
        this.verifyEncodedData(bOut);
    }

    public void testAttributeGenerators() throws Exception {
        final DERObjectIdentifier dummyOid1 = new DERObjectIdentifier("1.2.3");
        final DERObjectIdentifier dummyOid2 = new DERObjectIdentifier("1.2.3.4");
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        DefaultSignedAttributeTableGenerator signedGen = new DefaultSignedAttributeTableGenerator(){

            public AttributeTable getAttributes(Map parameters) {
                Hashtable table = this.createStandardAttributeTable(parameters);
                DEROctetString val = new DEROctetString((byte[])parameters.get("digest"));
                Attribute attr = new Attribute(dummyOid1, (ASN1Set)new DERSet((DEREncodable)val));
                table.put(attr.getAttrType(), attr);
                return new AttributeTable(table);
            }
        };
        CMSAttributeTableGenerator unsignedGen = new CMSAttributeTableGenerator(){

            public AttributeTable getAttributes(Map parameters) {
                DEROctetString val = new DEROctetString((byte[])parameters.get("encryptedDigest"));
                Attribute attr = new Attribute(dummyOid2, (ASN1Set)new DERSet((DEREncodable)val));
                return new AttributeTable((ASN1Set)new DERSet((DEREncodable)attr));
            }
        };
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, (CMSAttributeTableGenerator)signedGen, unsignedGen, BC);
        gen.addCertificatesAndCRLs(certs);
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
        SignerInformationStore signers = sp.getSignerInfos();
        Collection c = signers.getSigners();
        for (SignerInformation signer : c) {
            this.checkAttribute(signer.getContentDigest(), signer.getSignedAttributes().get(dummyOid1));
            this.checkAttribute(signer.getSignature(), signer.getUnsignedAttributes().get(dummyOid2));
        }
    }

    private void checkAttribute(byte[] expected, Attribute attr) {
        DEROctetString value = (DEROctetString)attr.getAttrValues().getObjectAt(0);
        SignedDataStreamTest.assertEquals((Object)new DEROctetString(expected), (Object)value);
    }

    public void testWithAttributeCertificate() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certs);
        X509AttributeCertificate attrCert = CMSTestUtil.getAttributeCertificate();
        X509Store store = X509Store.getInstance((String)"AttributeCertificate/Collection", (X509StoreParameters)new X509CollectionStoreParameters(Collections.singleton(attrCert)), (String)BC);
        gen.addAttributeCertificates(store);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        SignedDataStreamTest.assertEquals((int)4, (int)sp.getVersion());
        store = sp.getAttributeCertificates("Collection", BC);
        Collection coll = store.getMatches(null);
        SignedDataStreamTest.assertEquals((int)1, (int)coll.size());
        SignedDataStreamTest.assertTrue((boolean)coll.contains(attrCert));
    }

    public void testSignerStoreReplacement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        byte[] data = TEST_MESSAGE.getBytes();
        certList.add(_origCert);
        certList.add(_signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certs);
        OutputStream sigOut = gen.open(bOut, false);
        sigOut.write(data);
        sigOut.close();
        this.checkSigParseable(bOut.toByteArray());
        ByteArrayInputStream original = new ByteArrayInputStream(bOut.toByteArray());
        bOut.reset();
        gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA224, BC);
        gen.addCertificatesAndCRLs(certs);
        sigOut = gen.open(bOut);
        sigOut.write(data);
        sigOut.close();
        this.checkSigParseable(bOut.toByteArray());
        CMSSignedData sd = new CMSSignedData(bOut.toByteArray());
        ByteArrayOutputStream newOut = new ByteArrayOutputStream();
        CMSSignedDataParser.replaceSigners(original, sd.getSignerInfos(), newOut);
        sd = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(data), newOut.toByteArray());
        SignerInformation signer = (SignerInformation)sd.getSignerInfos().getSigners().iterator().next();
        SignedDataStreamTest.assertEquals((String)signer.getDigestAlgOID(), (String)CMSSignedDataStreamGenerator.DIGEST_SHA224);
        CMSSignedDataParser sp = new CMSSignedDataParser(new CMSTypedStream(new ByteArrayInputStream(data)), newOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
    }

    public void testEncapsulatedSignerStoreReplacement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certs);
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        ByteArrayInputStream original = new ByteArrayInputStream(bOut.toByteArray());
        bOut.reset();
        gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA224, BC);
        gen.addCertificatesAndCRLs(certs);
        sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedData sd = new CMSSignedData(bOut.toByteArray());
        ByteArrayOutputStream newOut = new ByteArrayOutputStream();
        CMSSignedDataParser.replaceSigners(original, sd.getSignerInfos(), newOut);
        sd = new CMSSignedData(newOut.toByteArray());
        SignerInformation signer = (SignerInformation)sd.getSignerInfos().getSigners().iterator().next();
        SignedDataStreamTest.assertEquals((String)signer.getDigestAlgOID(), (String)CMSSignedDataStreamGenerator.DIGEST_SHA224);
        CMSSignedDataParser sp = new CMSSignedDataParser(newOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
    }

    public void testCertStoreReplacement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        byte[] data = TEST_MESSAGE.getBytes();
        certList.add(_origDsaCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certs);
        OutputStream sigOut = gen.open(bOut);
        sigOut.write(data);
        sigOut.close();
        this.checkSigParseable(bOut.toByteArray());
        certList = new ArrayList();
        certList.add(_origCert);
        certList.add(_signCert);
        certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        ByteArrayInputStream original = new ByteArrayInputStream(bOut.toByteArray());
        ByteArrayOutputStream newOut = new ByteArrayOutputStream();
        CMSSignedDataParser.replaceCertificatesAndCRLs(original, certs, newOut);
        CMSSignedDataParser sp = new CMSSignedDataParser(new CMSTypedStream(new ByteArrayInputStream(data)), newOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
    }

    public void testEncapsulatedCertStoreReplacement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origDsaCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certs);
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        certList = new ArrayList();
        certList.add(_origCert);
        certList.add(_signCert);
        certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        ByteArrayInputStream original = new ByteArrayInputStream(bOut.toByteArray());
        ByteArrayOutputStream newOut = new ByteArrayOutputStream();
        CMSSignedDataParser.replaceCertificatesAndCRLs(original, certs, newOut);
        CMSSignedDataParser sp = new CMSSignedDataParser(newOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
    }

    public void testCertOrdering1() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certs);
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        certs = sp.getCertificatesAndCRLs("Collection", BC);
        Iterator<? extends Certificate> it = certs.getCertificates(null).iterator();
        SignedDataStreamTest.assertEquals((Object)_origCert, (Object)it.next());
        SignedDataStreamTest.assertEquals((Object)_signCert, (Object)it.next());
    }

    public void testCertOrdering2() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_signCert);
        certList.add(_origCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), BC);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
        gen.addCertificatesAndCRLs(certs);
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        certs = sp.getCertificatesAndCRLs("Collection", BC);
        Iterator<? extends Certificate> it = certs.getCertificates(null).iterator();
        SignedDataStreamTest.assertEquals((Object)_signCert, (Object)it.next());
        SignedDataStreamTest.assertEquals((Object)_origCert, (Object)it.next());
    }

    public static Test suite() throws Exception {
        SignedDataStreamTest.init();
        return new CMSTestSetup((Test)new TestSuite(SignedDataStreamTest.class));
    }

    static {
        _initialised = false;
    }
}

