/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.io.OutputStream;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.cms.CMSCompressedDataStreamGenerator;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEGenerator;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;

public class SMIMECompressedGenerator
extends SMIMEGenerator {
    public static final String ZLIB = "1.2.840.113549.1.9.16.3.8";
    private static final String COMPRESSED_CONTENT_TYPE = "application/pkcs7-mime; name=\"smime.p7z\"; smime-type=compressed-data";

    private MimeBodyPart make(MimeBodyPart content, String compressionOID) throws SMIMEException {
        try {
            MimeBodyPart data = new MimeBodyPart();
            data.setContent((Object)new ContentCompressor(content, compressionOID), COMPRESSED_CONTENT_TYPE);
            data.addHeader("Content-Type", COMPRESSED_CONTENT_TYPE);
            data.addHeader("Content-Disposition", "attachment; filename=\"smime.p7z\"");
            data.addHeader("Content-Description", "S/MIME Compressed Message");
            data.addHeader("Content-Transfer-Encoding", this.encoding);
            return data;
        }
        catch (MessagingException e) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)e));
        }
    }

    public MimeBodyPart generate(MimeBodyPart content, String compressionOID) throws SMIMEException {
        return this.make(this.makeContentBodyPart(content), compressionOID);
    }

    public MimeBodyPart generate(MimeMessage message, String compressionOID) throws SMIMEException {
        try {
            message.saveChanges();
        }
        catch (MessagingException e) {
            throw new SMIMEException("unable to save message", (Exception)((Object)e));
        }
        return this.make(this.makeContentBodyPart(message), compressionOID);
    }

    static {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mc.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        CommandMap.setDefaultCommandMap((CommandMap)mc);
    }

    private class ContentCompressor
    implements SMIMEStreamingProcessor {
        private final MimeBodyPart _content;
        private final String _compressionOid;

        ContentCompressor(MimeBodyPart content, String compressionOid) {
            this._content = content;
            this._compressionOid = compressionOid;
        }

        public void write(OutputStream out) throws IOException {
            CMSCompressedDataStreamGenerator cGen = new CMSCompressedDataStreamGenerator();
            OutputStream compressed = cGen.open(out, this._compressionOid);
            try {
                this._content.writeTo(compressed);
                compressed.close();
            }
            catch (MessagingException e) {
                throw new IOException(e.toString());
            }
        }
    }
}

