/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug;

import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.japura.Application;
import org.japura.debug.controllers.DebugControllerManager;
import org.japura.debug.tasks.DebugTasks;

public final class DebugWindow
extends JDialog {
    private static final long serialVersionUID = 3L;
    private JTabbedPane tabbedPane;

    public DebugWindow() {
        this.setDefaultCloseOperation(0);
        this.setModal(false);
        this.setSize(800, 500);
        this.setTitle("Japura - Debug");
        this.add(this.getTabbedPane());
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("", ((DebugControllerManager)Application.getControllerManager().get(DebugControllerManager.class)).getComponent());
            this.tabbedPane.addTab("", ((DebugTasks)Application.getControllerManager().get(DebugTasks.class)).getComponent());
        }
        return this.tabbedPane;
    }

    protected void updateTabTitles() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String title = ((DebugControllerManager)Application.getControllerManager().get(DebugControllerManager.class)).getTitle();
                DebugWindow.this.getTabbedPane().setTitleAt(0, title);
                title = ((DebugTasks)Application.getControllerManager().get(DebugTasks.class)).getTitle();
                DebugWindow.this.getTabbedPane().setTitleAt(1, title);
            }
        });
    }
}

