/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.japura.gui.TitlePanel;
import org.japura.util.info.InfoNode;

public class InfoNodeUtil {
    public static TitlePanel buildTitlePanel(String title, Collection<InfoNode> nodes, String ... excludeIdentifiers) {
        TitlePanel titlePanel = new TitlePanel(title);
        titlePanel.setBorder(BorderFactory.createLineBorder(Color.black));
        ArrayList<InfoNode> leafs = new ArrayList<InfoNode>();
        ArrayList<InfoNode> groups = new ArrayList<InfoNode>();
        for (InfoNode node : nodes) {
            boolean ignore = false;
            if (node.getIdentifier() != null) {
                for (String identifier : excludeIdentifiers) {
                    if (!identifier.equals(node.getIdentifier())) continue;
                    ignore = true;
                    break;
                }
            }
            if (ignore) continue;
            if (node.isLeaf()) {
                leafs.add(node);
                continue;
            }
            groups.add(node);
        }
        JPanel container = new JPanel();
        container.setBackground(Color.WHITE);
        container.setLayout((LayoutManager)new MigLayout("ins 10 10 10 10,wrap 2", "[align right][grow]"));
        for (InfoNode node : leafs) {
            JLabel label = new JLabel();
            label.setText(node.getName() + ":");
            JTextArea textArea = new JTextArea();
            textArea.setOpaque(false);
            textArea.setText(node.getValue());
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.setPreferredSize(new Dimension(10, 10));
            container.add(label);
            container.add((Component)textArea, "wmin 10, grow x");
        }
        for (InfoNode node : groups) {
            TitlePanel panel = InfoNodeUtil.buildTitlePanel(node.getName(), node.getChildren(), excludeIdentifiers);
            container.add((Component)panel, "span x, grow x");
        }
        titlePanel.add((Component)container);
        return titlePanel;
    }
}

