/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug.controllers;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.japura.Application;
import org.japura.controller.Context;
import org.japura.controller.Controller;
import org.japura.controller.DefaultController;
import org.japura.controller.messages.ControllerRegisterMessage;
import org.japura.controller.messages.ControllerUnregisterMessage;
import org.japura.debug.Debug;
import org.japura.debug.controllers.DebugControllerManagerPanel;
import org.japura.debug.controllers.views.context.ContextViewController;
import org.japura.debug.controllers.views.list.ListViewPanelController;
import org.japura.debug.controllers.views.tree.TreeViewController;
import org.japura.message.Message;

public class DebugControllerManager
extends DefaultController<DebugControllerManagerPanel>
implements Debug<DebugControllerManagerPanel> {
    private DebugControllerManagerPanel component;

    public DebugControllerManager(Context context, Controller parentController) {
        super(context, parentController);
        this.createChild(ListViewPanelController.class);
        this.createChild(ContextViewController.class);
        this.createChild(TreeViewController.class);
        this.update();
    }

    @Override
    public String getTitle() {
        int count = Application.getControllerManager().count();
        return "Controllers - count: " + count;
    }

    @Override
    public DebugControllerManagerPanel getComponent() {
        if (this.component == null) {
            this.component = new DebugControllerManagerPanel();
            this.component.getListButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListViewPanelController c = (ListViewPanelController)((Object)DebugControllerManager.this.getChild(ListViewPanelController.class));
                    DebugControllerManager.this.getComponent().updateViewComponent(c.getComponent());
                }
            });
            this.component.getTreeButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeViewController c = (TreeViewController)((Object)DebugControllerManager.this.getChild(TreeViewController.class));
                    DebugControllerManager.this.getComponent().updateViewComponent(c.getComponent());
                }
            });
            this.component.getContextButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContextViewController c = (ContextViewController)((Object)DebugControllerManager.this.getChild(ContextViewController.class));
                    DebugControllerManager.this.getComponent().updateViewComponent(c.getComponent());
                }
            });
            TreeViewController c = (TreeViewController)((Object)this.getChild(TreeViewController.class));
            this.component.updateViewComponent(c.getComponent());
        }
        return this.component;
    }

    public boolean isComponentInstancied() {
        return this.component != null;
    }

    public void subscribe(Message message, Object publisher) {
        super.subscribe(message, publisher);
        if (message instanceof ControllerRegisterMessage) {
            ControllerRegisterMessage crm = (ControllerRegisterMessage)message;
            if (crm.getRegisteredController().getGroupId().equals(this.getGroupId())) {
                return;
            }
            this.update();
        }
        if (message instanceof ControllerUnregisterMessage) {
            this.update();
        }
    }

    public void update() {
        TreeViewController tv;
        ListViewPanelController lv;
        ContextViewController cv = (ContextViewController)((Object)this.getChild(ContextViewController.class));
        if (cv != null) {
            cv.updateView();
        }
        if ((lv = (ListViewPanelController)((Object)this.getChild(ListViewPanelController.class))) != null) {
            lv.updateView();
        }
        if ((tv = (TreeViewController)((Object)this.getChild(TreeViewController.class))) != null) {
            tv.updateView();
        }
    }
}

