/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug.controllers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DebugControllerManagerPanel
extends JPanel {
    private static final long serialVersionUID = 3L;
    private JPanel buttonsPanel;
    private JRadioButton treeButton;
    private JRadioButton listButton;
    private JRadioButton contextButton;
    private JPanel viewContainer;

    public DebugControllerManagerPanel() {
        this.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.getButtonsPanel(), "North");
        this.add((Component)this.getViewContainer(), "Center");
    }

    public JPanel getViewContainer() {
        if (this.viewContainer == null) {
            this.viewContainer = new JPanel();
            this.viewContainer.setLayout(new BorderLayout());
        }
        return this.viewContainer;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            this.buttonsPanel.add((Component)new JLabel("Views:"), gbc);
            gbc.gridx = 1;
            this.buttonsPanel.add((Component)this.getTreeButton(), gbc);
            gbc.gridx = 2;
            this.buttonsPanel.add((Component)this.getListButton(), gbc);
            gbc.gridx = 3;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            this.buttonsPanel.add((Component)this.getContextButton(), gbc);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.getListButton());
            bg.add(this.getTreeButton());
            bg.add(this.getContextButton());
        }
        return this.buttonsPanel;
    }

    public JRadioButton getListButton() {
        if (this.listButton == null) {
            this.listButton = new JRadioButton("List");
        }
        return this.listButton;
    }

    public JRadioButton getTreeButton() {
        if (this.treeButton == null) {
            this.treeButton = new JRadioButton("Tree");
            this.treeButton.setSelected(true);
        }
        return this.treeButton;
    }

    public JRadioButton getContextButton() {
        if (this.contextButton == null) {
            this.contextButton = new JRadioButton("Contexts/Groups");
            this.contextButton.setSelected(true);
        }
        return this.contextButton;
    }

    public void updateViewComponent(JComponent component) {
        this.getViewContainer().removeAll();
        this.getViewContainer().add(component);
        this.getViewContainer().revalidate();
        this.repaint();
    }
}

