/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug.controllers.views.context;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.japura.Application;
import org.japura.controller.Context;
import org.japura.debug.controllers.views.context.ContextComponent;

public class ContextViewPanel
extends JPanel {
    private static final long serialVersionUID = 2L;
    private JPanel containerPanel = new JPanel();

    protected ContextViewPanel() {
        this.containerPanel.setLayout(new GridBagLayout());
        this.containerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.containerPanel.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.containerPanel);
        this.add(sp);
    }

    protected void updateView(final boolean withScreenshot) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = -1;
                ContextViewPanel.this.containerPanel.removeAll();
                Collection contexts = Application.getControllerManager().getContexts();
                for (Context context : contexts) {
                    ContextViewPanel.this.containerPanel.add((Component)new ContextComponent(context, withScreenshot), gbc);
                    gbc.insets = new Insets(20, 0, 0, 0);
                }
                ContextViewPanel.this.containerPanel.revalidate();
                ContextViewPanel.this.repaint();
            }
        });
    }
}

