/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug.controllers.views.list;

import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.japura.Application;
import org.japura.controller.Controller;
import org.japura.debug.controllers.views.list.InfoViewPanel;

public class ListViewPanel
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    private InfoViewPanel infoViewPanel;
    private JScrollPane scrollPaneList;
    private JScrollPane scrollPaneInfo;
    private JList list;

    protected ListViewPanel() {
        this.setLeftComponent(this.getScrollPaneList());
        this.setRightComponent(this.getScrollPaneInfo());
        this.setResizeWeight(0.5);
    }

    public JScrollPane getScrollPaneInfo() {
        if (this.scrollPaneInfo == null) {
            this.scrollPaneInfo = new JScrollPane(this.getInfoViewPanel());
        }
        return this.scrollPaneInfo;
    }

    public JScrollPane getScrollPaneList() {
        if (this.scrollPaneList == null) {
            this.scrollPaneList = new JScrollPane(this.getList());
        }
        return this.scrollPaneList;
    }

    public InfoViewPanel getInfoViewPanel() {
        if (this.infoViewPanel == null) {
            this.infoViewPanel = new InfoViewPanel();
        }
        return this.infoViewPanel;
    }

    public JList getList() {
        if (this.list == null) {
            this.list = new JList();
            this.list.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.list.setCellRenderer(new ListRenderer());
        }
        return this.list;
    }

    public void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Collection list = Application.getControllerManager().getAll();
                DefaultMutableTreeNode root = new DefaultMutableTreeNode();
                DefaultListModel<Controller> listModel = new DefaultListModel<Controller>();
                for (Controller c : list) {
                    if (c.getParentId() != null) continue;
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(c);
                    root.add(node);
                    listModel.addElement(c);
                    ListViewPanel.this.addChild(c, listModel);
                }
                ListViewPanel.this.getList().setModel(listModel);
            }
        });
    }

    private void addChild(Controller parent, DefaultListModel listModel) {
        Collection list = parent.getChildren();
        if (list.size() > 0) {
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                Controller child;
                Controller c = child = (Controller)i$.next();
                listModel.addElement(child);
                this.addChild(c, listModel);
            }
        }
    }

    private static String controllerToString(Controller controller, boolean fullName) {
        String name = null;
        name = fullName ? controller.getClass().getName() : controller.getClass().getSimpleName();
        return name + " [ " + controller.stringToDebugComponent() + " ]";
    }

    private class ListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 197732829250426432L;

        private ListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Controller controller = (Controller)value;
            boolean fullName = true;
            comp.setText(ListViewPanel.controllerToString(controller, fullName));
            return comp;
        }
    }
}

