/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug.controllers.views.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.japura.Application;
import org.japura.controller.Context;
import org.japura.controller.Controller;
import org.japura.debug.controllers.views.tree.InfoViewPanel;
import org.japura.debug.controllers.views.tree.Node;

public class TreeViewPanel
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    private InfoViewPanel infoViewPanel;
    private JScrollPane scrollPaneTree;
    private JScrollPane scrollPaneInfo;
    private JTree tree;

    protected TreeViewPanel() {
        this.setLeftComponent(this.getScrollPaneTree());
        this.setRightComponent(this.getScrollPaneInfo());
        this.setResizeWeight(0.5);
    }

    public JScrollPane getScrollPaneInfo() {
        if (this.scrollPaneInfo == null) {
            this.scrollPaneInfo = new JScrollPane(this.getInfoViewPanel());
        }
        return this.scrollPaneInfo;
    }

    public JScrollPane getScrollPaneTree() {
        if (this.scrollPaneTree == null) {
            this.scrollPaneTree = new JScrollPane(this.getTree());
        }
        return this.scrollPaneTree;
    }

    public InfoViewPanel getInfoViewPanel() {
        if (this.infoViewPanel == null) {
            this.infoViewPanel = new InfoViewPanel();
        }
        return this.infoViewPanel;
    }

    public JTree getTree() {
        if (this.tree == null) {
            this.tree = new JTree();
            this.tree.setModel(new DefaultTreeModel(new Node()));
            this.tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.tree.setCellRenderer(new TreeRenderer());
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    Node node = (Node)event.getPath().getLastPathComponent();
                    node.setExpanded(true);
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                }
            });
            this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath tp = e.getNewLeadSelectionPath();
                    if (tp != null) {
                        Node node = (Node)tp.getLastPathComponent();
                        TreeViewPanel.this.getInfoViewPanel().updateInfo(node);
                    } else {
                        TreeViewPanel.this.getInfoViewPanel().updateInfo(null);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TreeViewPanel.this.getScrollPaneInfo().getVerticalScrollBar().setValue(0);
                        }
                    });
                }
            });
        }
        return this.tree;
    }

    public void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTreeModel currentModel = (DefaultTreeModel)TreeViewPanel.this.getTree().getModel();
                Node currentRoot = (Node)currentModel.getRoot();
                ArrayList expandedNodes = new ArrayList();
                TreeViewPanel.this.fetchExpandedNodes(currentRoot, expandedNodes);
                Collection contexts = Application.getControllerManager().getContexts();
                Node root = new Node();
                DefaultTreeModel treeModel = new DefaultTreeModel(root);
                for (Context context : contexts) {
                    Node node = new Node(context);
                    root.add(node);
                    TreeViewPanel.this.addChild(context, node);
                }
                TreeViewPanel.this.upateTree(treeModel, expandedNodes);
            }
        });
    }

    private void addChild(Context parent, Node parentNode) {
        Collection list = parent.getAll();
        if (list.size() > 0) {
            for (Controller child : list) {
                if (!child.isRoot()) continue;
                Node childNode = new Node(child);
                parentNode.add(childNode);
                this.addChild(child, childNode);
            }
        }
    }

    private void addChild(Controller parent, Node parentNode) {
        Collection list = parent.getChildren();
        if (list.size() > 0) {
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                Controller child;
                Controller c = child = (Controller)i$.next();
                Node childNode = new Node(child);
                parentNode.add(childNode);
                this.addChild(c, childNode);
            }
        }
    }

    private void fetchExpandedNodes(Node node, List<String> expandedNodes) {
        if (!node.isRoot() && node.isExpanded()) {
            Object userObject = node.getUserObject();
            if (userObject instanceof Controller) {
                Controller controller = (Controller)userObject;
                expandedNodes.add(controller.getControllerId());
            } else if (userObject instanceof Context) {
                Context context = (Context)userObject;
                expandedNodes.add(context.getId());
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node cn = (Node)node.getChildAt(i);
            this.fetchExpandedNodes(cn, expandedNodes);
        }
    }

    private void upateTree(DefaultTreeModel newModel, List<String> expandedNodes) {
        ArrayList<TreePath> pathsToExpand = new ArrayList<TreePath>();
        Node root = (Node)newModel.getRoot();
        this.addToPathList(root, expandedNodes, pathsToExpand);
        this.getTree().setModel(newModel);
        for (TreePath tp : pathsToExpand) {
            this.getTree().expandPath(tp);
        }
    }

    private void addToPathList(Node node, List<String> expandedNodes, List<TreePath> pathsToExpand) {
        if (node.isRoot() && expandedNodes.size() > 0) {
            pathsToExpand.add(new TreePath(node.getPath()));
        }
        if (!node.isRoot()) {
            Context context;
            String id;
            Object userObject = node.getUserObject();
            if (userObject instanceof Controller) {
                Controller controller = (Controller)userObject;
                id = controller.getControllerId();
                if (expandedNodes.contains(id)) {
                    pathsToExpand.add(new TreePath(node.getPath()));
                }
            } else if (userObject instanceof Context && expandedNodes.contains(id = (context = (Context)userObject).getId())) {
                pathsToExpand.add(new TreePath(node.getPath()));
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node cn = (Node)node.getChildAt(i);
            this.addToPathList(cn, expandedNodes, pathsToExpand);
        }
    }

    private class TreeRenderer
    extends JPanel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private JPanel panel = new JPanel();
        private JLabel label1 = new JLabel();
        private JLabel label2 = new JLabel();
        private Border selectedBorder = BorderFactory.createLineBorder(Color.BLACK, 3);
        private Border unselectedBorder;

        public TreeRenderer() {
            MatteBorder out = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.WHITE);
            Border in = BorderFactory.createLineBorder(Color.BLACK);
            this.unselectedBorder = BorderFactory.createCompoundBorder(out, in);
            this.setLayout((LayoutManager)new MigLayout("ins 3 3 3 3", "grow", "grow"));
            this.setOpaque(false);
            this.panel.setLayout((LayoutManager)new MigLayout("wrap 1", "", "[]1[]"));
            this.panel.add(this.label1);
            this.panel.add(this.label2);
            this.add((Component)this.panel, "grow");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (sel) {
                this.panel.setBorder(this.selectedBorder);
            } else {
                this.panel.setBorder(this.unselectedBorder);
            }
            Node node = (Node)value;
            Object userObject = node.getUserObject();
            if (userObject != null) {
                if (userObject instanceof Context) {
                    Context context = (Context)userObject;
                    this.label1.setText("Context");
                    this.label2.setText("Name: " + context.getName());
                    this.panel.setBackground(new Color(250, 230, 170));
                } else if (userObject instanceof Controller) {
                    Controller controller = (Controller)userObject;
                    Class<?> clss = controller.getClass();
                    this.label1.setText("Package: " + clss.getPackage().getName());
                    this.label2.setText("Class: " + clss.getSimpleName());
                    this.panel.setBackground(new Color(190, 220, 250));
                } else {
                    this.label1.setText(userObject.toString());
                    this.label2.setText("");
                    this.panel.setBackground(Color.WHITE);
                }
            } else {
                this.label1.setText("");
                this.label2.setText("");
                this.panel.setBackground(Color.WHITE);
            }
            return this;
        }
    }
}

