/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug.tasks;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.japura.gui.CheckComboBox;
import org.japura.gui.event.ListCheckListener;
import org.japura.gui.event.ListEvent;
import org.japura.gui.model.ListCheckModel;
import org.japura.task.messages.notify.TaskEvent;
import org.japura.task.messages.notify.TaskEventType;

public class DebugTasksEventPanel
extends JPanel {
    private static final long serialVersionUID = 4L;
    private CheckComboBox eventComboBox;
    private CheckComboBox columnComboBox;
    private JPanel northPanel;
    private JButton clearButton;
    private JTable table;
    private List<TaskEvent> taskEvents;
    private List<Column> visibleColumns;
    private JCheckBox lastEventOnlyCheck;
    private List<TaskEvent> removeList = new ArrayList<TaskEvent>();

    public DebugTasksEventPanel() {
        this.visibleColumns = new ArrayList<Column>();
        ListCheckModel model = this.getColumnComboBox().getModel();
        for (Column column : Column.values()) {
            model.addElement(new Object[]{column});
            if (!column.isDefaultEnabled()) continue;
            model.addCheck(new Object[]{column});
            this.visibleColumns.add(column);
        }
        model.addListCheckListener(new ListCheckListener(){

            public void removeCheck(ListEvent event) {
                this.updateVisibleColumns();
            }

            public void addCheck(ListEvent event) {
                this.updateVisibleColumns();
            }

            private void updateVisibleColumns() {
                DebugTasksEventPanel.this.visibleColumns.clear();
                for (Object obj : DebugTasksEventPanel.this.getColumnComboBox().getModel().getCheckeds()) {
                    DebugTasksEventPanel.this.visibleColumns.add((Column)((Object)obj));
                }
                DebugTasksEventPanel.this.getTable().tableChanged(null);
                DebugTasksEventPanel.this.getTable().repaint();
            }
        });
        this.taskEvents = new ArrayList<TaskEvent>();
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.getTable()), "Center");
        this.add((Component)this.getNorthPanel(), "North");
    }

    private JCheckBox getLastEventOnlyCheck() {
        if (this.lastEventOnlyCheck == null) {
            this.lastEventOnlyCheck = new JCheckBox();
            this.lastEventOnlyCheck.setText("last event only");
        }
        return this.lastEventOnlyCheck;
    }

    protected JTable getTable() {
        if (this.table == null) {
            this.table = new JTable();
            this.table.setModel(new Model());
        }
        return this.table;
    }

    private JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel();
            FlowLayout fl = new FlowLayout(0);
            this.northPanel.setLayout(fl);
            this.northPanel.add(new JLabel("Events:"));
            this.northPanel.add((Component)this.getEventComboBox());
            this.northPanel.add(new JLabel("Columns:"));
            this.northPanel.add((Component)this.getColumnComboBox());
            this.northPanel.add(this.getLastEventOnlyCheck());
            this.northPanel.add(this.getClearButton());
        }
        return this.northPanel;
    }

    private CheckComboBox getEventComboBox() {
        if (this.eventComboBox == null) {
            this.eventComboBox = new CheckComboBox();
            this.eventComboBox.setTextFor(CheckComboBox.NONE, "* any item selected *");
            this.eventComboBox.setTextFor(CheckComboBox.MULTIPLE, "* multiple items *");
            this.eventComboBox.setTextFor(CheckComboBox.ALL, "* all selected *");
            ListCheckModel model = this.eventComboBox.getModel();
            for (TaskEventType te : TaskEventType.values()) {
                model.addElement(new Object[]{te});
                if (te.equals((Object)TaskEventType.AFTER) || te.equals((Object)TaskEventType.BEFORE)) continue;
                model.addCheck(new Object[]{te});
            }
        }
        return this.eventComboBox;
    }

    private CheckComboBox getColumnComboBox() {
        if (this.columnComboBox == null) {
            this.columnComboBox = new CheckComboBox();
            this.columnComboBox.setTextFor(CheckComboBox.NONE, "* any item selected *");
            this.columnComboBox.setTextFor(CheckComboBox.MULTIPLE, "* multiple items *");
            this.columnComboBox.setTextFor(CheckComboBox.ALL, "* all selected *");
        }
        return this.columnComboBox;
    }

    protected JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton("Clear");
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DebugTasksEventPanel.this.taskEvents.clear();
                    DebugTasksEventPanel.this.getTable().revalidate();
                }
            });
        }
        return this.clearButton;
    }

    public void addTaskDebugLog(final TaskEvent event) {
        if (!this.getEventComboBox().getModel().isChecked((Object)event.getEventType())) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DebugTasksEventPanel.this.getLastEventOnlyCheck().isSelected()) {
                    String id = event.getTaskId();
                    for (TaskEvent event2 : DebugTasksEventPanel.this.taskEvents) {
                        if (!event2.getTaskId().equals(id)) continue;
                        DebugTasksEventPanel.this.removeList.add(event2);
                    }
                    int index = -1;
                    if (DebugTasksEventPanel.this.removeList.size() > 0) {
                        index = DebugTasksEventPanel.this.taskEvents.indexOf(DebugTasksEventPanel.this.removeList.get(0));
                    }
                    DebugTasksEventPanel.this.taskEvents.removeAll(DebugTasksEventPanel.this.removeList);
                    DebugTasksEventPanel.this.removeList.clear();
                    if (index > -1) {
                        DebugTasksEventPanel.this.taskEvents.add(index, event);
                    } else {
                        DebugTasksEventPanel.this.taskEvents.add(event);
                    }
                } else {
                    DebugTasksEventPanel.this.taskEvents.add(event);
                }
                DebugTasksEventPanel.this.getTable().revalidate();
                DebugTasksEventPanel.this.getTable().repaint();
            }
        });
    }

    static enum Column {
        ID("Id", false),
        CLASS("Class", true),
        NAME("Name", true),
        EVENT("Event", true),
        EDT("EDT", false),
        TIME_SPENT("TimeSpent(doInBackground)", false),
        WAIT_FOR_EDT("WaitForEDT", false),
        START_TIME("StartTime", false),
        TASK_EXECUTOR("TaskExecutor", true),
        SESSION("Session", false);

        private boolean defaultEnabled;
        private String columnName;

        private Column(String name, boolean defaultEnabled) {
            this.columnName = name;
            this.defaultEnabled = defaultEnabled;
        }

        public boolean isDefaultEnabled() {
            return this.defaultEnabled;
        }

        public String toString() {
            return this.columnName;
        }
    }

    private class Model
    implements TableModel {
        private Date date = new Date();

        private Model() {
        }

        @Override
        public int getRowCount() {
            return DebugTasksEventPanel.this.taskEvents.size();
        }

        @Override
        public int getColumnCount() {
            return DebugTasksEventPanel.this.visibleColumns.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            Column column = (Column)((Object)DebugTasksEventPanel.this.visibleColumns.get(columnIndex));
            return column.toString();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Column column = (Column)((Object)DebugTasksEventPanel.this.visibleColumns.get(columnIndex));
            TaskEvent event = (TaskEvent)DebugTasksEventPanel.this.taskEvents.get(rowIndex);
            if (column.equals((Object)Column.ID)) {
                return event.getTaskId();
            }
            if (column.equals((Object)Column.NAME)) {
                return event.getName();
            }
            if (column.equals((Object)Column.CLASS)) {
                return event.getTaskClass();
            }
            if (column.equals((Object)Column.EVENT)) {
                return event.getEventType();
            }
            if (column.equals((Object)Column.EDT)) {
                if (event.isEdt()) {
                    return "yes";
                }
                return "no";
            }
            if (column.equals((Object)Column.TIME_SPENT)) {
                return event.getTimeSpent();
            }
            if (column.equals((Object)Column.WAIT_FOR_EDT)) {
                if (event.isWaitForEDT()) {
                    return "yes";
                }
                return "no";
            }
            if (column.equals((Object)Column.START_TIME)) {
                this.date.setTime(event.getStartTime());
                return this.date.toString();
            }
            if (column.equals((Object)Column.TASK_EXECUTOR)) {
                return event.getSource();
            }
            if (column.equals((Object)Column.SESSION)) {
                return event.getSession();
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

