/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug.tasks;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;
import org.japura.debug.tasks.DebugTasksEventPanel;
import org.japura.debug.tasks.executions.DebugTasksExecutionsPanel;

public class DebugTasksPanel
extends JPanel {
    private static final long serialVersionUID = 4L;
    private DebugTasksExecutionsPanel executionsPanel;
    private DebugTasksEventPanel eventPanel;
    private JRadioButton eventView;
    private JRadioButton executionView;
    private JPanel contentPanel;

    public DebugTasksPanel() {
        this.setLayout((LayoutManager)new MigLayout("", "grow", "[][grow]"));
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.add((Component)new JLabel("views:"), "split 3");
        this.add(this.getEventView());
        this.add((Component)this.getExecutionView(), "wrap");
        this.add((Component)this.contentPanel, "grow");
        this.contentPanel.add(this.getEventPanel());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.getEventView());
        bg.add(this.getExecutionView());
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugTasksPanel.this.updateView();
            }
        };
        this.getEventView().addActionListener(l);
        this.getExecutionView().addActionListener(l);
    }

    private void updateView() {
        this.contentPanel.removeAll();
        if (this.getEventView().isSelected()) {
            this.contentPanel.add(this.getEventPanel());
        } else {
            this.contentPanel.add(this.getExecutionsPanel());
        }
        this.contentPanel.revalidate();
        this.repaint();
    }

    public JRadioButton getEventView() {
        if (this.eventView == null) {
            this.eventView = new JRadioButton();
            this.eventView.setText("events");
            this.eventView.setSelected(true);
        }
        return this.eventView;
    }

    public JRadioButton getExecutionView() {
        if (this.executionView == null) {
            this.executionView = new JRadioButton();
            this.executionView.setText("executions");
        }
        return this.executionView;
    }

    public DebugTasksExecutionsPanel getExecutionsPanel() {
        if (this.executionsPanel == null) {
            this.executionsPanel = new DebugTasksExecutionsPanel();
        }
        return this.executionsPanel;
    }

    public DebugTasksEventPanel getEventPanel() {
        if (this.eventPanel == null) {
            this.eventPanel = new DebugTasksEventPanel();
        }
        return this.eventPanel;
    }
}

