/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug.tasks.executions;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.japura.debug.tasks.executions.Execution;
import org.japura.debug.tasks.executions.ExecutionViewPanel;
import org.japura.debug.tasks.executions.InfoViewPanel;
import org.japura.debug.tasks.executions.TaskPanelListener;

public class DebugTasksExecutionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TaskPanelListener listener;
    private ExecutionViewPanel executionPanel;
    private InfoViewPanel infoPanel;
    private JScrollPane infoPanelScrollPane;
    private JSplitPane splitPane;
    private JButton clearButton;

    public DebugTasksExecutionsPanel() {
        this.setLayout((LayoutManager)new MigLayout("ins 0 0 0 0, wrap 1", "grow", "[][grow]"));
        this.add(this.getClearButton());
        this.add((Component)this.getSplitPane(), "grow");
    }

    public JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setLeftComponent(new JScrollPane(this.getExecutionPanel()));
            this.splitPane.setRightComponent(this.getInfoPanelScrollPane());
            this.splitPane.setResizeWeight(0.0);
        }
        return this.splitPane;
    }

    public JScrollPane getInfoPanelScrollPane() {
        if (this.infoPanelScrollPane == null) {
            this.infoPanelScrollPane = new JScrollPane(this.getInfoPanel());
        }
        return this.infoPanelScrollPane;
    }

    public JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton();
            this.clearButton.setText("Clear");
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DebugTasksExecutionsPanel.this.getInfoPanel().clear();
                    DebugTasksExecutionsPanel.this.getExecutionPanel().clear();
                    DebugTasksExecutionsPanel.this.repaint();
                }
            });
        }
        return this.clearButton;
    }

    public ExecutionViewPanel getExecutionPanel() {
        if (this.executionPanel == null) {
            this.executionPanel = new ExecutionViewPanel(this.getListener());
        }
        return this.executionPanel;
    }

    public InfoViewPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPanel = new InfoViewPanel();
        }
        return this.infoPanel;
    }

    public TaskPanelListener getListener() {
        if (this.listener == null) {
            this.listener = new TaskPanelListener(){

                @Override
                public void action(Execution e) {
                    DebugTasksExecutionsPanel.this.getExecutionPanel().updateSelection(e);
                    DebugTasksExecutionsPanel.this.getInfoPanel().action(e);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DebugTasksExecutionsPanel.this.infoPanelScrollPane.getVerticalScrollBar().setValue(DebugTasksExecutionsPanel.this.infoPanelScrollPane.getVerticalScrollBar().getMinimum());
                        }
                    });
                }
            };
        }
        return this.listener;
    }
}

