/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.yaml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.exception.LiquibaseParseException;
import liquibase.parser.SnapshotParser;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.yaml.YamlParser;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.RestoredDatabaseSnapshot;
import liquibase.util.StreamUtil;
import org.yaml.snakeyaml.Yaml;

public class YamlSnapshotParser
extends YamlParser
implements SnapshotParser {
    @Override
    public DatabaseSnapshot parse(String path, ResourceAccessor resourceAccessor) throws LiquibaseParseException {
        Yaml yaml = new Yaml();
        try {
            Map parsedYaml;
            InputStream stream = StreamUtil.singleInputStream(path, resourceAccessor);
            if (stream == null) {
                throw new LiquibaseParseException(path + " does not exist");
            }
            try {
                parsedYaml = (Map)yaml.loadAs((Reader)new InputStreamReader(stream, "UTF-8"), Map.class);
            }
            catch (Exception e) {
                throw new LiquibaseParseException("Syntax error in " + this.getSupportedFileExtensions()[0] + ": " + e.getMessage(), e);
            }
            Map rootList = (Map)parsedYaml.get("snapshot");
            if (rootList == null) {
                throw new LiquibaseParseException("Could not find root snapshot node");
            }
            String shortName = (String)((Map)rootList.get("database")).get("shortName");
            Database database = (Database)DatabaseFactory.getInstance().getDatabase(shortName).getClass().newInstance();
            RestoredDatabaseSnapshot snapshot = new RestoredDatabaseSnapshot(database);
            ParsedNode snapshotNode = new ParsedNode(null, "snapshot");
            snapshotNode.setValue(rootList);
            Map metadata = (Map)rootList.get("metadata");
            if (metadata != null) {
                snapshot.getMetadata().putAll(metadata);
            }
            snapshot.load(snapshotNode, resourceAccessor);
            return snapshot;
        }
        catch (Throwable e) {
            if (e instanceof LiquibaseParseException) {
                throw (LiquibaseParseException)e;
            }
            throw new LiquibaseParseException(e);
        }
    }
}

