/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.value.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.ExtendedValue;
import org.msgpack.value.ValueType;
import org.msgpack.value.ValueVisitor;
import org.msgpack.value.impl.RawValueImpl;

public class ExtendedValueImpl
extends RawValueImpl
implements ExtendedValue {
    private final int type;

    public ExtendedValueImpl(int n, ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.type = n;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.EXTENDED;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packExtendedTypeHeader(this.type, this.byteBuffer.remaining());
        messagePacker.writePayload(this.byteBuffer);
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitExtended(this);
    }

    @Override
    public ExtendedValue toValue() {
        return this;
    }

    @Override
    public int getExtType() {
        return this.type;
    }
}

