/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.artifactory;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.BasicHeader;
import org.owasp.dependencycheck.data.artifactory.ArtifactorySearchResponseHandler;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ArtifactorySearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactorySearch.class);
    private final String rootURL;
    private final boolean allowUsingProxy;

    public ArtifactorySearch(Settings settings) {
        String searchUrl;
        this.rootURL = searchUrl = settings.getString("analyzer.artifactory.url");
        LOGGER.debug("Artifactory Search URL {}", (Object)searchUrl);
        if (null != settings.getString("proxy.server")) {
            this.allowUsingProxy = settings.getBoolean("analyzer.artifactory.proxy", false);
            LOGGER.debug("Using proxy configuration? {}", (Object)this.allowUsingProxy);
        } else {
            this.allowUsingProxy = settings.getBoolean("analyzer.artifactory.proxy", true);
            LOGGER.debug("Using default non-legacy proxy configuration");
        }
    }

    public List<MavenArtifact> search(Dependency dependency) throws IOException {
        String sha1sum = dependency.getSha1sum();
        URL url = this.buildUrl(sha1sum);
        StringBuilder msg = new StringBuilder("Could not connect to Artifactory at").append(url);
        try {
            BasicHeader artifactoryResultDetail = new BasicHeader("X-Result-Detail", (Object)"info");
            return (List)Downloader.getInstance().fetchAndHandle(url, (HttpClientResponseHandler)new ArtifactorySearchResponseHandler(dependency), List.of(artifactoryResultDetail), this.allowUsingProxy);
        }
        catch (TooManyRequestsException e) {
            throw new IOException(msg.append(" (429): Too manu requests").toString(), e);
        }
        catch (URISyntaxException e) {
            throw new IOException(msg.append(" (400): Invalid URL").toString(), e);
        }
        catch (ResourceNotFoundException e) {
            throw new IOException(msg.append(" (404): Not found").toString(), e);
        }
    }

    private URL buildUrl(String sha1sum) throws MalformedURLException {
        return new URL(this.rootURL + "/api/search/checksum?sha1=" + sha1sum);
    }

    public boolean preflightRequest() {
        URL url = null;
        try {
            url = this.buildUrl(Checksum.getSHA1Checksum((String)UUID.randomUUID().toString()));
            Downloader.getInstance().fetchContent(url, StandardCharsets.UTF_8);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Cannot connect to Artifactory", (Throwable)e);
            return false;
        }
        catch (TooManyRequestsException e) {
            LOGGER.warn("Expected 200 result from Artifactory ({}), got 429", (Object)url);
            return false;
        }
        catch (ResourceNotFoundException e) {
            LOGGER.warn("Expected 200 result from Artifactory ({}), got 404", (Object)url);
            return false;
        }
    }
}

