/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.engine.CompositeCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.owasp.dependencycheck.data.cache.DataCache;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nodeaudit.Advisory;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.xml.pom.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCacheFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataCacheFactory.class);
    private static final String CACHE_DIRECTORY = "cache";
    private static final String CACHE_PROPERTIES = "dependencycheck-cache.properties";
    private static Boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCacheFactory(Settings settings) {
        Class<DataCacheFactory> clazz = DataCacheFactory.class;
        synchronized (DataCacheFactory.class) {
            if (!initialized.booleanValue()) {
                File cacheDirectory;
                try {
                    cacheDirectory = new File(settings.getDataDirectory(), CACHE_DIRECTORY);
                }
                catch (IOException ex) {
                    throw new CacheException("Unable to obtain disk cache directory path", (Throwable)ex);
                }
                if (!cacheDirectory.isDirectory() && !cacheDirectory.mkdirs()) {
                    throw new CacheException("Unable to create disk cache: " + cacheDirectory);
                }
                try (InputStream in = FileUtils.getResourceAsStream((String)CACHE_PROPERTIES);){
                    if (in == null) {
                        throw new RuntimeException("Cache properties `dependencycheck-cache.properties` could not be found");
                    }
                    Properties properties = new Properties();
                    properties.load(in);
                    properties.put("jcs.auxiliary.ODC.attributes.DiskPath", cacheDirectory.getCanonicalPath());
                    for (CacheType t : CacheType.values()) {
                        File fp = new File(cacheDirectory, t.toString());
                        properties.put("jcs.auxiliary." + t + ".attributes.DiskPath", fp.getCanonicalPath());
                    }
                    JCS.setConfigProperties((Properties)properties);
                    initialized = true;
                }
                catch (IOException ex) {
                    throw new CacheException("Error creating disk cache", (Throwable)ex);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public DataCache<List<Advisory>> getNodeAuditCache() {
        try {
            CompositeCacheAttributes attr = new CompositeCacheAttributes();
            attr.setUseDisk(true);
            attr.setUseLateral(false);
            attr.setUseRemote(false);
            CacheAccess ca = JCS.getInstance((String)"NODEAUDIT", (ICompositeCacheAttributes)attr);
            DataCache<List<Advisory>> dc = new DataCache<List<Advisory>>(ca);
            return dc;
        }
        catch (Throwable ex) {
            if (ex instanceof CacheException) {
                throw ex;
            }
            LOGGER.debug("Error constructing cache for node audit files", ex);
            throw new CacheException(ex);
        }
    }

    public DataCache<Model> getPomCache() {
        try {
            CompositeCacheAttributes attr = new CompositeCacheAttributes();
            attr.setUseDisk(true);
            attr.setUseLateral(false);
            attr.setUseRemote(false);
            CacheAccess ca = JCS.getInstance((String)"POM", (ICompositeCacheAttributes)attr);
            DataCache<Model> dc = new DataCache<Model>(ca);
            return dc;
        }
        catch (Throwable ex) {
            if (ex instanceof CacheException) {
                throw ex;
            }
            LOGGER.debug("Error constructing cache for POM files", ex);
            throw new CacheException(ex);
        }
    }

    public DataCache<List<MavenArtifact>> getCentralCache() {
        try {
            CompositeCacheAttributes attr = new CompositeCacheAttributes();
            attr.setUseDisk(true);
            attr.setUseLateral(false);
            attr.setUseRemote(false);
            CacheAccess ca = JCS.getInstance((String)"CENTRAL", (ICompositeCacheAttributes)attr);
            DataCache<List<MavenArtifact>> dc = new DataCache<List<MavenArtifact>>(ca);
            return dc;
        }
        catch (Throwable ex) {
            if (ex instanceof CacheException) {
                throw ex;
            }
            LOGGER.debug("Error constructing cache for Central files", ex);
            throw new CacheException(ex);
        }
    }

    private static enum CacheType {
        NODEAUDIT,
        CENTRAL,
        POM;

    }
}

