/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd.api;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.github.jeremylong.openvulnerability.client.nvd.DefCveItem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;
import org.owasp.dependencycheck.data.update.nvd.api.CveItemSource;

public class JsonArrayCveItemSource
implements CveItemSource<DefCveItem> {
    private final File jsonFile;
    private final ObjectMapper mapper;
    private final InputStream inputStream;
    private final JsonParser jsonParser;
    private DefCveItem currentItem;
    private DefCveItem nextItem;

    public JsonArrayCveItemSource(File jsonFile) throws IOException {
        this.jsonFile = jsonFile;
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new JavaTimeModule());
        this.inputStream = jsonFile.getName().endsWith(".gz") ? new BufferedInputStream(new GZIPInputStream(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]))) : new BufferedInputStream(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]));
        this.jsonParser = this.mapper.getFactory().createParser(this.inputStream);
        if (this.jsonParser.nextToken() == JsonToken.START_ARRAY) {
            this.nextItem = this.readItem(this.jsonParser);
        }
    }

    @Override
    public void close() throws Exception {
        this.jsonParser.close();
        this.inputStream.close();
        Files.delete(this.jsonFile.toPath());
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null;
    }

    @Override
    public DefCveItem next() throws IOException {
        this.currentItem = this.nextItem;
        this.nextItem = this.readItem(this.jsonParser);
        return this.currentItem;
    }

    private DefCveItem readItem(JsonParser jsonParser) throws IOException {
        if (jsonParser.nextToken() == JsonToken.START_OBJECT) {
            return (DefCveItem)this.mapper.readValue(jsonParser, DefCveItem.class);
        }
        return null;
    }
}

