/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeBinding;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationBinding;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;

class ResourceBuilderRoot
implements ResourceBuilder {
    private final PathElement pathElement;
    private final StandardResourceDescriptionResolver resourceResolver;
    private final List<AttributeBinding> attributes = new LinkedList<AttributeBinding>();
    private final List<OperationBinding> operations = new LinkedList<OperationBinding>();
    private ResourceDescriptionResolver attributeResolver = null;
    private OperationStepHandler addHandler;
    private OperationStepHandler removeHandler;
    private final ResourceBuilderRoot parent;
    private final List<ResourceBuilderRoot> children = new LinkedList<ResourceBuilderRoot>();

    private ResourceBuilderRoot(PathElement pathElement, StandardResourceDescriptionResolver resourceResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler, ResourceBuilderRoot parent) {
        this.pathElement = pathElement;
        this.resourceResolver = resourceResolver;
        this.parent = parent;
        this.addHandler = addHandler;
        this.removeHandler = removeHandler;
    }

    static ResourceBuilder create(PathElement pathElement, StandardResourceDescriptionResolver resourceDescriptionResolver) {
        return new ResourceBuilderRoot(pathElement, resourceDescriptionResolver, null, null, null);
    }

    static ResourceBuilder create(PathElement pathElement, StandardResourceDescriptionResolver resourceResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        return new ResourceBuilderRoot(pathElement, resourceResolver, addHandler, removeHandler, null);
    }

    @Override
    public ResourceBuilder setAddOperation(AbstractAddStepHandler handler) {
        this.addHandler = handler;
        return this;
    }

    @Override
    public ResourceBuilder setRemoveOperation(AbstractRemoveStepHandler handler) {
        this.removeHandler = handler;
        return this;
    }

    @Override
    public ResourceBuilder setAddOperation(RestartParentResourceAddHandler handler) {
        this.addHandler = handler;
        return this;
    }

    @Override
    public ResourceBuilder setRemoveOperation(RestartParentResourceRemoveHandler handler) {
        this.removeHandler = handler;
        return this;
    }

    @Override
    public ResourceBuilder addReadWriteAttribute(AttributeDefinition attributeDefinition, OperationStepHandler reader, OperationStepHandler writer) {
        this.attributes.add(new AttributeBinding(attributeDefinition, reader, writer, AttributeAccess.AccessType.READ_WRITE));
        return this;
    }

    @Override
    public ResourceBuilder addReadWriteAttributes(OperationStepHandler reader, OperationStepHandler writer, AttributeDefinition ... attributes) {
        for (AttributeDefinition ad : attributes) {
            this.attributes.add(new AttributeBinding(ad, reader, writer, AttributeAccess.AccessType.READ_WRITE));
        }
        return this;
    }

    @Override
    public ResourceBuilder addReadOnlyAttribute(AttributeDefinition attributeDefinition) {
        this.attributes.add(new AttributeBinding(attributeDefinition, null, null, AttributeAccess.AccessType.READ_ONLY));
        return this;
    }

    @Override
    public ResourceBuilder addMetric(AttributeDefinition attributeDefinition, OperationStepHandler handler) {
        this.attributes.add(new AttributeBinding(attributeDefinition, handler, null, AttributeAccess.AccessType.METRIC));
        return this;
    }

    @Override
    public ResourceBuilder addMetrics(OperationStepHandler metricHandler, AttributeDefinition ... attributes) {
        for (AttributeDefinition ad : attributes) {
            this.attributes.add(new AttributeBinding(ad, metricHandler, null, AttributeAccess.AccessType.METRIC));
        }
        return this;
    }

    @Override
    public ResourceBuilder setAttributeResolver(ResourceDescriptionResolver resolver) {
        this.attributeResolver = resolver;
        return this;
    }

    @Override
    public ResourceBuilder addOperation(OperationDefinition operationDefinition, OperationStepHandler handler) {
        return this.addOperation(operationDefinition, handler, false);
    }

    @Override
    public ResourceBuilder addOperation(OperationDefinition operationDefinition, OperationStepHandler handler, boolean inherited) {
        this.operations.add(new OperationBinding(operationDefinition, handler, inherited));
        return this;
    }

    @Override
    public ResourceBuilder pushChild(PathElement pathElement) {
        return this.pushChild(pathElement, this.resourceResolver.getChildResolver(pathElement.getKey()));
    }

    @Override
    public ResourceBuilder pushChild(PathElement pathElement, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        return this.pushChild(pathElement, this.resourceResolver.getChildResolver(pathElement.getKey()), addHandler, removeHandler);
    }

    @Override
    public ResourceBuilder pushChild(PathElement pathElement, StandardResourceDescriptionResolver resolver) {
        return this.pushChild(pathElement, resolver, null, null);
    }

    @Override
    public ResourceBuilder pushChild(PathElement pathElement, StandardResourceDescriptionResolver resolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        ResourceBuilderRoot child = new ResourceBuilderRoot(pathElement, resolver, addHandler, removeHandler, this);
        this.children.add(child);
        return child;
    }

    @Override
    public ResourceBuilder pushChild(ResourceBuilder child) {
        ChildBuilderDelegate childDelegate = new ChildBuilderDelegate((ResourceBuilderRoot)child, this);
        this.children.add(childDelegate);
        return childDelegate;
    }

    @Override
    public ResourceBuilder pop() {
        if (this.parent == null) {
            return this;
        }
        return this.parent;
    }

    @Override
    public ResourceDefinition build() {
        if (this.parent != null) {
            return this.parent.build();
        }
        return new BuilderResourceDefinition(this);
    }

    List<AttributeBinding> getAttributes() {
        return this.attributes;
    }

    List<OperationBinding> getOperations() {
        return this.operations;
    }

    List<ResourceBuilderRoot> getChildren() {
        return this.children;
    }

    static final class ChildBuilderDelegate
    extends ResourceBuilderRoot {
        ChildBuilderDelegate(ResourceBuilderRoot child, ResourceBuilderRoot parent) {
            super(child.pathElement, child.resourceResolver, child.addHandler, child.removeHandler, parent);
            this.getChildren().addAll(child.children);
            this.getAttributes().addAll(child.attributes);
            this.getOperations().addAll(child.operations);
        }
    }

    private class BuilderResourceDefinition
    extends SimpleResourceDefinition {
        final ResourceBuilderRoot builder;

        private BuilderResourceDefinition(ResourceBuilderRoot builder) {
            super(builder.pathElement, builder.resourceResolver, builder.addHandler, builder.removeHandler);
            this.builder = builder;
        }

        @Override
        public void registerOperations(ManagementResourceRegistration resourceRegistration) {
            super.registerOperations(resourceRegistration);
            for (OperationBinding ob : ResourceBuilderRoot.this.operations) {
                ob.register(resourceRegistration);
            }
        }

        @Override
        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            super.registerAttributes(resourceRegistration);
            for (AttributeBinding ab : this.builder.attributes) {
                ab.register(resourceRegistration);
            }
        }

        @Override
        public void registerChildren(ManagementResourceRegistration resourceRegistration) {
            super.registerChildren(resourceRegistration);
            for (ResourceBuilderRoot child : this.builder.children) {
                resourceRegistration.registerSubModel(new BuilderResourceDefinition(child));
            }
        }
    }
}

