/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Collection;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.notification.NotificationHandler;
import org.jboss.as.controller.registry.AtomicMapFieldUpdater;
import org.jboss.as.controller.registry.ConcreteNotificationHandlerRegistration;
import org.jboss.as.controller.registry.NotificationHandlerNodeSubregistry;

class NotificationHandlerNodeRegistry {
    private final String value;
    private final NotificationHandlerNodeSubregistry parent;
    private volatile Map<String, NotificationHandlerNodeSubregistry> children;
    private volatile Collection<ConcreteNotificationHandlerRegistration.NotificationHandlerEntry> entries;
    private static final AtomicMapFieldUpdater<NotificationHandlerNodeRegistry, String, NotificationHandlerNodeSubregistry> childrenUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(NotificationHandlerNodeRegistry.class, Map.class, "children"));

    NotificationHandlerNodeRegistry(String value, NotificationHandlerNodeSubregistry parent) {
        this.value = value;
        this.parent = parent;
        childrenUpdater.clear(this);
        this.entries = new CopyOnWriteArraySet<ConcreteNotificationHandlerRegistration.NotificationHandlerEntry>();
    }

    void registerEntry(ListIterator<PathElement> iterator, ConcreteNotificationHandlerRegistration.NotificationHandlerEntry entry) {
        if (!iterator.hasNext()) {
            this.entries.add(entry);
            return;
        }
        PathElement element = iterator.next();
        NotificationHandlerNodeSubregistry subregistry = this.getOrCreateSubregistry(element.getKey());
        subregistry.registerEntry(iterator, element.getValue(), entry);
    }

    void unregisterEntry(ListIterator<PathElement> iterator, ConcreteNotificationHandlerRegistration.NotificationHandlerEntry entry) {
        if (!iterator.hasNext()) {
            this.entries.remove(entry);
            return;
        }
        PathElement element = iterator.next();
        NotificationHandlerNodeSubregistry subregistry = this.children.get(element.getKey());
        if (subregistry == null) {
            return;
        }
        subregistry.unregisterEntry(iterator, element.getValue(), entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findEntries(ListIterator<PathElement> iterator, Collection<NotificationHandler> handlers, Notification notification) {
        if (!iterator.hasNext()) {
            for (ConcreteNotificationHandlerRegistration.NotificationHandlerEntry entry : this.entries) {
                if (!entry.getFilter().isNotificationEnabled(notification)) continue;
                handlers.add(entry.getHandler());
            }
            return;
        }
        PathElement next = iterator.next();
        try {
            NotificationHandlerNodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return;
            }
            subregistry.findHandlers(iterator, next.getValue(), notification, handlers);
        }
        finally {
            iterator.previous();
        }
    }

    String getLocationString() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.getLocationString() + this.value + ")";
    }

    NotificationHandlerNodeSubregistry getOrCreateSubregistry(String key) {
        NotificationHandlerNodeSubregistry newRegistry;
        NotificationHandlerNodeSubregistry appearing;
        do {
            Map<String, NotificationHandlerNodeSubregistry> snapshot;
            NotificationHandlerNodeSubregistry subregistry;
            if ((subregistry = (snapshot = childrenUpdater.get(this)).get(key)) != null) {
                return subregistry;
            }
            newRegistry = new NotificationHandlerNodeSubregistry(key, this);
            appearing = childrenUpdater.putAtomic(this, key, newRegistry, snapshot);
            if (appearing != null) continue;
            return newRegistry;
        } while (appearing == newRegistry);
        return appearing;
    }
}

