/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.impl.AbstractDelegatingAsyncFuture;
import org.jboss.as.controller.remote.SecurityActions;
import org.jboss.as.controller.remote.SubjectProtocolUtil;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.remote.TransactionalProtocolHandlers;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

class TransactionalProtocolClientImpl
implements ManagementRequestHandlerFactory,
TransactionalProtocolClient {
    private final ManagementChannelAssociation channelAssociation;

    public TransactionalProtocolClientImpl(ManagementChannelAssociation channelAssociation) {
        assert (channelAssociation != null);
        this.channelAssociation = channelAssociation;
    }

    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        byte operationType = header.getOperationId();
        if (operationType == 72) {
            return new HandleReportRequestHandler();
        }
        if (operationType == 76) {
            return ReadAttachmentInputStreamRequestHandler.INSTANCE;
        }
        return handlers.resolveNext();
    }

    @Override
    public AsyncFuture<ModelNode> execute(TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation> listener, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments) throws IOException {
        TransactionalProtocolClient.Operation wrapper = TransactionalProtocolHandlers.wrap(operation, messageHandler, attachments);
        return this.execute(listener, wrapper);
    }

    @Override
    public <T extends TransactionalProtocolClient.Operation> AsyncFuture<ModelNode> execute(TransactionalProtocolClient.TransactionalOperationListener<T> listener, T operation) throws IOException {
        Subject subject = SecurityActions.getSubject();
        ExecuteRequestContext context = new ExecuteRequestContext(new OperationWrapper<T>(listener, operation), subject);
        final ActiveOperation op = this.channelAssociation.initializeOperation((Object)context, (ActiveOperation.CompletedCallback)context);
        AbstractDelegatingAsyncFuture<ModelNode> result = new AbstractDelegatingAsyncFuture<ModelNode>(op.getResult()){

            public void asyncCancel(boolean interruptionDesired) {
                try {
                    TransactionalProtocolClientImpl.this.channelAssociation.executeRequest(op, (ManagementRequest)new CompleteTxRequest(113));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        context.initialize((AsyncFuture<ModelNode>)result);
        this.channelAssociation.executeRequest(op, (ManagementRequest)new ExecuteRequest());
        return result;
    }

    static ModelNode getFailureResponse(String outcome, String message) {
        ModelNode response = new ModelNode();
        response.get("outcome").set(outcome);
        if (message != null) {
            response.get("failure-description").set(message);
        }
        return response;
    }

    static ModelNode getResponse(String outcome) {
        return TransactionalProtocolClientImpl.getFailureResponse(outcome, null);
    }

    static void writeSubject(FlushableDataOutput output, Subject subject) throws IOException {
        SubjectProtocolUtil.write((DataOutput)output, subject);
    }

    static class PreparedOperationImpl<T extends TransactionalProtocolClient.Operation>
    implements TransactionalProtocolClient.PreparedOperation<T> {
        private final T operation;
        private final ModelNode preparedResult;
        private final AsyncFuture<ModelNode> finalResult;
        private final ModelController.OperationTransaction transaction;

        protected PreparedOperationImpl(T operation, ModelNode preparedResult, AsyncFuture<ModelNode> finalResult, ModelController.OperationTransaction transaction) {
            assert (finalResult != null) : "null result";
            this.operation = operation;
            this.preparedResult = preparedResult;
            this.finalResult = finalResult;
            this.transaction = transaction;
        }

        @Override
        public T getOperation() {
            return this.operation;
        }

        @Override
        public ModelNode getPreparedResult() {
            return this.preparedResult;
        }

        @Override
        public boolean isFailed() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.finalResult.isDone();
        }

        @Override
        public AsyncFuture<ModelNode> getFinalResult() {
            return this.finalResult;
        }

        @Override
        public void commit() {
            this.transaction.commit();
        }

        @Override
        public void rollback() {
            this.transaction.rollback();
        }
    }

    private static class OperationWrapper<T extends TransactionalProtocolClient.Operation> {
        private final T operation;
        private final TransactionalProtocolClient.TransactionalOperationListener<T> listener;
        private AsyncFuture<ModelNode> future;

        OperationWrapper(TransactionalProtocolClient.TransactionalOperationListener<T> listener, T operation) {
            this.listener = listener;
            this.operation = operation;
        }

        OperationMessageHandler getMessageHandler() {
            return this.operation.getMessageHandler();
        }

        ModelNode getOperation() {
            return this.operation.getOperation();
        }

        OperationAttachments getAttachments() {
            return this.operation.getAttachments();
        }

        void prepared(ModelController.OperationTransaction transaction, ModelNode result) {
            PreparedOperationImpl<T> preparedOperation = new PreparedOperationImpl<T>(this.operation, result, this.future, transaction);
            this.listener.operationPrepared(preparedOperation);
        }

        void completed(ModelNode response) {
            this.listener.operationComplete(this.operation, response);
        }

        void failed(ModelNode response) {
            this.listener.operationFailed(this.operation, response);
        }
    }

    static class ExecuteRequestContext
    implements ActiveOperation.CompletedCallback<ModelNode> {
        final OperationWrapper<?> wrapper;
        final AtomicBoolean completed = new AtomicBoolean(false);
        final Subject subject;

        ExecuteRequestContext(OperationWrapper<?> operationWrapper, Subject subject) {
            this.wrapper = operationWrapper;
            this.subject = subject;
        }

        void initialize(AsyncFuture<ModelNode> result) {
            ((OperationWrapper)this.wrapper).future = result;
        }

        OperationMessageHandler getMessageHandler() {
            return this.wrapper.getMessageHandler();
        }

        ModelNode getOperation() {
            return this.wrapper.getOperation();
        }

        OperationAttachments getAttachments() {
            return this.wrapper.getAttachments();
        }

        List<InputStream> getInputStreams() {
            OperationAttachments attachments = this.getAttachments();
            if (attachments == null) {
                return Collections.emptyList();
            }
            return attachments.getInputStreams();
        }

        Subject getSerializableSubject() {
            if (this.subject != null) {
                Subject toSend = new Subject();
                Set<Principal> principals = toSend.getPrincipals();
                for (Principal current : this.subject.getPrincipals()) {
                    if (!(current instanceof Serializable)) continue;
                    principals.add(current);
                }
                toSend.setReadOnly();
                return toSend;
            }
            return null;
        }

        public synchronized void completed(ModelNode result) {
            if (this.completed.compareAndSet(false, true)) {
                this.wrapper.completed(result);
            }
        }

        public void failed(Exception e) {
            this.operationFailed(TransactionalProtocolClientImpl.getFailureResponse("failed", e.getMessage()));
        }

        public void cancelled() {
            this.operationFailed(TransactionalProtocolClientImpl.getResponse("cancelled"));
        }

        synchronized void operationFailed(ModelNode response) {
            if (this.completed.compareAndSet(false, true)) {
                this.wrapper.failed(response);
            }
        }

        synchronized void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
            this.wrapper.prepared(transaction, result);
        }
    }

    private static class ReadAttachmentInputStreamRequestHandler
    implements ManagementRequestHandler<ModelNode, ExecuteRequestContext> {
        static final ReadAttachmentInputStreamRequestHandler INSTANCE = new ReadAttachmentInputStreamRequestHandler();

        private ReadAttachmentInputStreamRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)102);
            final int index = input.readInt();
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<ExecuteRequestContext> context) throws Exception {
                    ExecuteRequestContext exec = (ExecuteRequestContext)context.getAttachment();
                    ManagementRequestHeader header = (ManagementRequestHeader)ManagementRequestHeader.class.cast(context.getRequestHeader());
                    ManagementResponseHeader response = new ManagementResponseHeader(header.getVersion(), header.getRequestId(), null);
                    InputStream is = (InputStream)exec.getAttachments().getInputStreams().get(index);
                    ByteArrayOutputStream bout = ReadAttachmentInputStreamRequestHandler.this.copyStream(is);
                    FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)response);
                    try {
                        output.writeByte(103);
                        output.writeInt(bout.size());
                        output.writeByte(104);
                        output.write(bout.toByteArray());
                        output.writeByte(36);
                        output.close();
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)output);
                    }
                }
            });
        }

        protected ByteArrayOutputStream copyStream(InputStream is) throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (is != null) {
                StreamUtils.copyStream((InputStream)is, (OutputStream)bout);
            }
            return bout;
        }
    }

    private static class HandleReportRequestHandler
    implements ManagementRequestHandler<ModelNode, ExecuteRequestContext> {
        private HandleReportRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)98);
            MessageSeverity severity = Enum.valueOf(MessageSeverity.class, input.readUTF());
            ProtocolUtils.expectHeader((DataInput)input, (int)99);
            String message = input.readUTF();
            ProtocolUtils.expectHeader((DataInput)input, (int)21);
            ExecuteRequestContext requestContext = (ExecuteRequestContext)context.getAttachment();
            OperationMessageHandler handler = requestContext.getMessageHandler();
            handler.handleReport(severity, message);
        }
    }

    private static class CompleteTxRequest
    extends AbstractManagementRequest<ModelNode, ExecuteRequestContext> {
        private final byte status;

        private CompleteTxRequest(byte status) {
            this.status = status;
        }

        public byte getOperationType() {
            return 78;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<ExecuteRequestContext> context, FlushableDataOutput output) throws IOException {
            output.write((int)this.status);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)74);
            ModelNode response = new ModelNode();
            response.readExternal(input);
            resultHandler.done((Object)response);
        }
    }

    private class ExecuteRequest
    extends AbstractManagementRequest<ModelNode, ExecuteRequestContext> {
        private ExecuteRequest() {
        }

        public byte getOperationType() {
            return 71;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<ExecuteRequestContext> context, FlushableDataOutput output) throws IOException {
            ExecuteRequestContext executionContext = (ExecuteRequestContext)context.getAttachment();
            List<InputStream> streams = executionContext.getInputStreams();
            ModelNode operation = executionContext.getOperation();
            int inputStreamLength = 0;
            if (streams != null) {
                inputStreamLength = streams.size();
            }
            output.write(97);
            operation.writeExternal((DataOutput)output);
            output.write(101);
            output.writeInt(inputStreamLength);
            Boolean sendSubject = (Boolean)TransactionalProtocolClientImpl.this.channelAssociation.getAttachments().getAttachment(TransactionalProtocolClient.SEND_SUBJECT);
            if (sendSubject != null && sendSubject.booleanValue()) {
                Subject subject = ((ExecuteRequestContext)context.getAttachment()).getSerializableSubject();
                TransactionalProtocolClientImpl.writeSubject(output, subject);
            }
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<ModelNode> resultHandler, final ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            byte responseType = input.readByte();
            ModelNode response = new ModelNode();
            response.readExternal(input);
            boolean prepared = responseType == 75;
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)context.getAttachment();
            if (prepared) {
                executeRequestContext.operationPrepared(new ModelController.OperationTransaction(){

                    @Override
                    public void rollback() {
                        this.done(false);
                    }

                    @Override
                    public void commit() {
                        this.done(true);
                    }

                    private void done(boolean commit) {
                        byte status = commit ? (byte)112 : 113;
                        try {
                            TransactionalProtocolClientImpl.this.channelAssociation.executeRequest(context.getOperationId(), (ManagementRequest)new CompleteTxRequest(status));
                        }
                        catch (Exception e) {
                            resultHandler.failed(e);
                        }
                    }
                }, response);
            } else {
                executeRequestContext.operationFailed(response);
                resultHandler.done((Object)response);
            }
        }
    }
}

