/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.Krb5Callback;

public class JaasCallbackHandler
implements CallbackHandler {
    private final String username;
    private final String password;
    final RemotingConnection remotingConnection;

    public JaasCallbackHandler(String username, String password, RemotingConnection remotingConnection) {
        this.username = username;
        this.password = password;
        this.remotingConnection = remotingConnection;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                if (this.password == null) {
                    passwordCallback.setPassword(null);
                    continue;
                }
                passwordCallback.setPassword(this.password.toCharArray());
                continue;
            }
            if (callback instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callback;
                if (this.username == null) {
                    nameCallback.setName(null);
                    continue;
                }
                nameCallback.setName(this.username);
                continue;
            }
            if (callback instanceof CertificateCallback) {
                CertificateCallback certCallback = (CertificateCallback)callback;
                certCallback.setCertificates(CertificateUtil.getCertsFromConnection((RemotingConnection)this.remotingConnection));
                continue;
            }
            if (callback instanceof Krb5Callback) {
                Iterator<KerberosPrincipal> iterator;
                Krb5Callback krb5Callback = (Krb5Callback)callback;
                Subject peerSubject = this.remotingConnection.getSubject();
                if (peerSubject != null && (iterator = peerSubject.getPrivateCredentials(KerberosPrincipal.class).iterator()).hasNext()) {
                    Principal principal = iterator.next();
                    krb5Callback.setPeerPrincipal(principal);
                    return;
                }
                krb5Callback.setPeerPrincipal(CertificateUtil.getPeerPrincipalFromConnection((RemotingConnection)this.remotingConnection));
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

