/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.security.Permission;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.security.permission.AbstractNamedPermission;
import org.wildfly.security.permission.AbstractPermission;
import org.wildfly.security.permission.NameSetPermissionCollection;
import org.wildfly.security.util.EnumerationIterator;
import org.wildfly.security.util.StringEnumeration;

final class IntNameSetPermissionCollection
extends NameSetPermissionCollection {
    private final AtomicInteger bitSet = new AtomicInteger();

    IntNameSetPermissionCollection(AbstractPermission<?> sourcePermission, StringEnumeration nameEnumeration) {
        super(sourcePermission, nameEnumeration);
    }

    private Permission permissionFor(int id) {
        return ((AbstractNamedPermission)this.getSourcePermission()).withName(this.getNameEnumeration().nameOf(id));
    }

    @Override
    protected void doAdd(AbstractPermission<?> permission) {
        int oldVal;
        int setBits = this.getBitsForName(permission);
        AtomicInteger bitSet = this.bitSet;
        do {
            if (((oldVal = bitSet.get()) & setBits) != setBits) continue;
            return;
        } while (!bitSet.compareAndSet(oldVal, oldVal | setBits));
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission.getClass() != this.getSourcePermission().getClass()) {
            return false;
        }
        long testBits = this.getBitsForName(permission);
        return ((long)this.bitSet.get() & testBits) == testBits;
    }

    @Override
    public int size() {
        int size = Integer.bitCount(this.bitSet.get());
        return size == this.getNameEnumeration().size() ? 1 : size;
    }

    @Override
    public EnumerationIterator<Permission> iterator() {
        return new Iter(this.bitSet.get());
    }

    public EnumerationIterator<Permission> elements() {
        return this.iterator();
    }

    private int getBitsForName(Permission permission) {
        String name = permission.getName();
        StringEnumeration nameEnumeration = this.getNameEnumeration();
        int bits = "*".equals(name) ? (1 << nameEnumeration.size()) - 1 : 1 << nameEnumeration.indexOf(name);
        return bits;
    }

    private class Iter
    implements EnumerationIterator<Permission> {
        private int bits;

        Iter(int bits) {
            this.bits = bits;
        }

        @Override
        public boolean hasMoreElements() {
            return this.bits != 0;
        }

        @Override
        public Permission nextElement() {
            int bits = this.bits;
            if (bits == 0) {
                throw new NoSuchElementException();
            }
            if (Integer.bitCount(bits) == IntNameSetPermissionCollection.this.getNameEnumeration().size()) {
                this.bits = 0;
                return ((AbstractNamedPermission)IntNameSetPermissionCollection.this.getSourcePermission()).withName("*");
            }
            int bit = Integer.lowestOneBit(bits);
            this.bits = bits & ~bit;
            return IntNameSetPermissionCollection.this.permissionFor(Integer.numberOfTrailingZeros(bit));
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public Permission next() {
            return this.nextElement();
        }
    }
}

