/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public final class PolicyConstraintsExtension
extends X509CertificateExtension {
    private final int requireExplicitPolicy;
    private final int inhibitPolicyMapping;

    public PolicyConstraintsExtension(int requireExplicitPolicy, int inhibitPolicyMapping) {
        super(true);
        this.requireExplicitPolicy = requireExplicitPolicy;
        this.inhibitPolicyMapping = inhibitPolicyMapping;
    }

    @Override
    public String getId() {
        return "2.5.29.36";
    }

    @Override
    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        if (this.requireExplicitPolicy >= 0) {
            encoder.encodeImplicit(0);
            encoder.encodeInteger(this.requireExplicitPolicy);
        }
        if (this.inhibitPolicyMapping >= 0) {
            encoder.encodeImplicit(1);
            encoder.encodeInteger(this.inhibitPolicyMapping);
        }
        encoder.endSequence();
    }
}

