/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.module.ExtensionInfo;
import org.jboss.as.server.moduleservice.ExtensionIndex;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceController;

public final class ModuleExtensionNameProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ExtensionInfo extensionInfo = deploymentUnit.getAttachment(Attachments.EXTENSION_INFORMATION);
        if (extensionInfo == null) {
            return;
        }
        ServiceController extensionIndexController = phaseContext.getServiceRegistry().getRequiredService(Services.JBOSS_DEPLOYMENT_EXTENSION_INDEX);
        ExtensionIndex extensionIndexService = (ExtensionIndex)extensionIndexController.getValue();
        ModuleIdentifier moduleIdentifier = deploymentUnit.getAttachment(Attachments.MODULE_IDENTIFIER);
        extensionIndexService.addDeployedExtension(moduleIdentifier, extensionInfo);
    }

    @Override
    public void undeploy(DeploymentUnit deploymentUnit) {
        ExtensionInfo extensionInfo = deploymentUnit.getAttachment(Attachments.EXTENSION_INFORMATION);
        if (extensionInfo == null) {
            return;
        }
        ServiceController extensionIndexController = deploymentUnit.getServiceRegistry().getRequiredService(Services.JBOSS_DEPLOYMENT_EXTENSION_INDEX);
        ExtensionIndex extensionIndexService = (ExtensionIndex)extensionIndexController.getValue();
        ModuleIdentifier moduleIdentifier = deploymentUnit.getAttachment(Attachments.MODULE_IDENTIFIER);
        extensionIndexService.removeDeployedExtension(extensionInfo.getName(), moduleIdentifier);
    }
}

