/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl;

import java.io.PrintWriter;

public class Comment {
    static final int UNKNOWN = -1;
    static final int JAVA_DOC = 0;
    static final int C_BLOCK = 1;
    static final int CPP_LINE = 2;
    private static String _eol = System.getProperty("line.separator");
    private String _text = new String("");
    private int _style = -1;

    Comment() {
        this._text = new String("");
        this._style = -1;
    }

    Comment(String text) {
        this._text = text;
        this._style = this.style(this._text);
    }

    public void text(String string) {
        this._text = string;
        this._style = this.style(this._text);
    }

    public String text() {
        return this._text;
    }

    private int style(String text) {
        if (text == null) {
            return -1;
        }
        if (text.startsWith("/**") && text.endsWith("*/")) {
            return 0;
        }
        if (text.startsWith("/*") && text.endsWith("*/")) {
            return 1;
        }
        if (text.startsWith("//")) {
            return 2;
        }
        return -1;
    }

    public void write() {
        System.out.println(this._text);
    }

    public void generate(String indent, PrintWriter printStream) {
        if (this._text == null || printStream == null) {
            return;
        }
        if (indent == null) {
            indent = new String("");
        }
        switch (this._style) {
            case 0: {
                this.print(indent, printStream);
                break;
            }
            case 1: {
                this.print(indent, printStream);
                break;
            }
            case 2: {
                this.print(indent, printStream);
                break;
            }
        }
    }

    private void print(String indent, PrintWriter stream) {
        String text = this._text.trim() + _eol;
        String line = null;
        int iLineStart = 0;
        int iLineEnd = text.indexOf(_eol);
        int iTextEnd = text.length() - 1;
        stream.println();
        while (iLineStart < iTextEnd) {
            line = text.substring(iLineStart, iLineEnd);
            stream.println(indent + line);
            iLineStart = iLineEnd + _eol.length();
            iLineEnd = iLineStart + text.substring(iLineStart).indexOf(_eol);
        }
    }

    private void printJavaDoc(String indent, PrintWriter stream) {
        String text = this._text.substring(3, this._text.length() - 2).trim() + _eol;
        String line = null;
        int iLineStart = 0;
        int iLineEnd = text.indexOf(_eol);
        int iTextEnd = text.length() - 1;
        stream.println(_eol + indent + "/**");
        while (iLineStart < iTextEnd) {
            line = text.substring(iLineStart, iLineEnd).trim();
            if (line.startsWith("*")) {
                stream.println(indent + " * " + line.substring(1, line.length()).trim());
            } else {
                stream.println(indent + " * " + line);
            }
            iLineStart = iLineEnd + _eol.length();
            iLineEnd = iLineStart + text.substring(iLineStart).indexOf(_eol);
        }
        stream.println(indent + " */");
    }

    private void printCBlock(String indent, PrintWriter stream) {
        String text = this._text.substring(2, this._text.length() - 2).trim() + _eol;
        String line = null;
        int iLineStart = 0;
        int iLineEnd = text.indexOf(_eol);
        int iTextEnd = text.length() - 1;
        stream.println(indent + "/*");
        while (iLineStart < iTextEnd) {
            line = text.substring(iLineStart, iLineEnd).trim();
            if (line.startsWith("*")) {
                stream.println(indent + " * " + line.substring(1, line.length()).trim());
            } else {
                stream.println(indent + " * " + line);
            }
            iLineStart = iLineEnd + _eol.length();
            iLineEnd = iLineStart + text.substring(iLineStart).indexOf(_eol);
        }
        stream.println(indent + " */");
    }

    private void printCppLine(String indent, PrintWriter stream) {
        stream.println(indent + "//");
        stream.println(indent + "// " + this._text.substring(2).trim());
        stream.println(indent + "//");
    }
}

