/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.Set;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.mod_cluster.CustomLoadMetricResourceDefinition;
import org.wildfly.extension.mod_cluster.DynamicLoadProviderResourceDefinition;
import org.wildfly.extension.mod_cluster.LoadMetricResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterExtension;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ModClusterModel;
import org.wildfly.extension.mod_cluster.ProxyConfigurationResourceDefinition;

public class LegacyMetricOperationsRegistration
implements Registration<ManagementResourceRegistration> {
    public void register(ManagementResourceRegistration registration) {
        SimpleOperationDefinition legacyAddMetricOperation = new SimpleOperationDefinitionBuilder("add-metric", (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).addParameter(LoadMetricResourceDefinition.Attribute.TYPE.getDefinition()).addParameter(LoadMetricResourceDefinition.SharedAttribute.WEIGHT.getDefinition()).addParameter(LoadMetricResourceDefinition.SharedAttribute.CAPACITY.getDefinition()).addParameter(LoadMetricResourceDefinition.SharedAttribute.PROPERTY.getDefinition()).setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        OperationStepHandler legacyAddMetricHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                LegacyMetricOperationsRegistration.operationDeprecated(context, operation);
                PathAddress address = LegacyMetricOperationsRegistration.translateProxyPath(context);
                String type = operation.require(LoadMetricResourceDefinition.Attribute.TYPE.getName()).asString();
                PathAddress metricPath = PathAddress.pathAddress((PathElement[])new PathElement[]{DynamicLoadProviderResourceDefinition.LEGACY_PATH, LoadMetricResourceDefinition.pathElement(type)});
                PathAddress metricPathAddress = address.append(metricPath);
                ModelNode metricOperation = Util.createAddOperation((PathAddress)metricPathAddress);
                OperationEntry addOperationEntry = context.getResourceRegistration().getOperationEntry(PathAddress.pathAddress((PathAddress)metricPath, (PathElement[])new PathElement[0]), "add");
                for (AttributeDefinition attribute : addOperationEntry.getOperationDefinition().getParameters()) {
                    String name = attribute.getName();
                    if (!operation.hasDefined(name)) continue;
                    metricOperation.get(name).set(operation.get(name));
                }
                context.addStep(metricOperation, addOperationEntry.getOperationHandler(), OperationContext.Stage.MODEL, true);
            }
        };
        registration.registerOperationHandler((OperationDefinition)legacyAddMetricOperation, legacyAddMetricHandler);
        SimpleOperationDefinition legacyRemoveMetricOperation = new SimpleOperationDefinitionBuilder("remove-metric", (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).addParameter(LoadMetricResourceDefinition.Attribute.TYPE.getDefinition()).setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        OperationStepHandler legacyRemoveMetricHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                LegacyMetricOperationsRegistration.operationDeprecated(context, operation);
                PathAddress address = LegacyMetricOperationsRegistration.translateProxyPath(context);
                String type = operation.require(LoadMetricResourceDefinition.Attribute.TYPE.getName()).asString();
                PathAddress metricPath = PathAddress.pathAddress((PathElement[])new PathElement[]{DynamicLoadProviderResourceDefinition.LEGACY_PATH, LoadMetricResourceDefinition.pathElement(type)});
                PathAddress metricPathAddress = address.append(metricPath);
                ModelNode metricOperation = Util.createRemoveOperation((PathAddress)metricPathAddress);
                OperationEntry removeOperationEntry = context.getResourceRegistration().getOperationEntry(PathAddress.pathAddress((PathAddress)metricPath, (PathElement[])new PathElement[0]), "remove");
                context.addStep(metricOperation, removeOperationEntry.getOperationHandler(), OperationContext.Stage.MODEL, true);
            }
        };
        registration.registerOperationHandler((OperationDefinition)legacyRemoveMetricOperation, legacyRemoveMetricHandler);
        SimpleOperationDefinition legacyAddCustomMetricOperation = new SimpleOperationDefinitionBuilder("add-custom-metric", (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).addParameter(CustomLoadMetricResourceDefinition.Attribute.CLASS.getDefinition()).addParameter(LoadMetricResourceDefinition.SharedAttribute.WEIGHT.getDefinition()).addParameter(LoadMetricResourceDefinition.SharedAttribute.CAPACITY.getDefinition()).addParameter(LoadMetricResourceDefinition.SharedAttribute.PROPERTY.getDefinition()).setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        OperationStepHandler legacyAddCustomMetricHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                LegacyMetricOperationsRegistration.operationDeprecated(context, operation);
                PathAddress address = LegacyMetricOperationsRegistration.translateProxyPath(context);
                String type = operation.require(CustomLoadMetricResourceDefinition.Attribute.CLASS.getName()).asString();
                PathAddress metricPath = PathAddress.pathAddress((PathElement[])new PathElement[]{DynamicLoadProviderResourceDefinition.LEGACY_PATH, LoadMetricResourceDefinition.pathElement(type)});
                PathAddress metricPathAddress = address.append(metricPath);
                ModelNode metricOperation = Util.createAddOperation((PathAddress)metricPathAddress);
                OperationEntry addOperationEntry = context.getResourceRegistration().getOperationEntry(PathAddress.pathAddress((PathAddress)metricPath, (PathElement[])new PathElement[0]), "add");
                for (AttributeDefinition attribute : addOperationEntry.getOperationDefinition().getParameters()) {
                    String name = attribute.getName();
                    if (!operation.hasDefined(name)) continue;
                    metricOperation.get(name).set(operation.get(name));
                }
                context.addStep(metricOperation, addOperationEntry.getOperationHandler(), OperationContext.Stage.MODEL, true);
            }
        };
        registration.registerOperationHandler((OperationDefinition)legacyAddCustomMetricOperation, legacyAddCustomMetricHandler);
        SimpleOperationDefinition legacyRemoveCustomMetricOperation = new SimpleOperationDefinitionBuilder("remove-custom-metric", (ResourceDescriptionResolver)ModClusterExtension.SUBSYSTEM_RESOLVER).addParameter(CustomLoadMetricResourceDefinition.Attribute.CLASS.getDefinition()).setDeprecated(ModClusterModel.VERSION_6_0_0.getVersion()).build();
        OperationStepHandler legacyRemoveCustomMetricHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                LegacyMetricOperationsRegistration.operationDeprecated(context, operation);
                PathAddress address = LegacyMetricOperationsRegistration.translateProxyPath(context);
                String type = operation.require(CustomLoadMetricResourceDefinition.Attribute.CLASS.getName()).asString();
                PathAddress metricPath = PathAddress.pathAddress((PathElement[])new PathElement[]{DynamicLoadProviderResourceDefinition.LEGACY_PATH, LoadMetricResourceDefinition.pathElement(type)});
                PathAddress metricPathAddress = address.append(metricPath);
                ModelNode metricOperation = Util.createRemoveOperation((PathAddress)metricPathAddress);
                OperationEntry removeOperationEntry = context.getResourceRegistration().getOperationEntry(PathAddress.pathAddress((PathAddress)metricPath, (PathElement[])new PathElement[0]), "remove");
                context.addStep(metricOperation, removeOperationEntry.getOperationHandler(), OperationContext.Stage.MODEL, true);
            }
        };
        registration.registerOperationHandler((OperationDefinition)legacyRemoveCustomMetricOperation, legacyRemoveCustomMetricHandler);
    }

    static PathAddress translateProxyPath(OperationContext context) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress().getParent();
        Set children = context.readResourceFromRoot(address).getChildren(ProxyConfigurationResourceDefinition.WILDCARD_PATH.getKey());
        if (children.size() != 1) {
            throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.legacyOperationsWithMultipleProxies());
        }
        PathAddress proxyPath = PathAddress.pathAddress((PathElement[])new PathElement[]{ProxyConfigurationResourceDefinition.pathElement(((Resource.ResourceEntry)children.iterator().next()).getName())});
        address = address.append(proxyPath);
        return address;
    }

    private static void operationDeprecated(OperationContext context, ModelNode operation) {
        ControllerLogger.DEPRECATED_LOGGER.operationDeprecated(Operations.getName((ModelNode)operation), context.getCurrentAddress().toCLIStyleString());
    }
}

