/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Set;
import javax.batch.api.BatchProperty;
import javax.batch.api.Batchlet;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import org.jberet._private.BatchMessages;
import org.jberet.repository.DefaultJobExecutionSelector;
import org.jberet.repository.InMemoryRepository;
import org.jberet.repository.InfinispanRepository;
import org.jberet.repository.JdbcRepository;
import org.jberet.repository.JobExecutionSelector;
import org.jberet.repository.JobRepository;
import org.jberet.repository.MongoRepository;
import org.jberet.runtime.context.JobContextImpl;

public class PurgeBatchlet
implements Batchlet {
    @Inject
    protected JobContext jobContext;
    @Inject
    protected StepContext stepContext;
    @Inject
    @BatchProperty
    protected String sql;
    @Inject
    @BatchProperty
    protected String sqlFile;
    @Inject
    @BatchProperty
    protected String mongoRemoveQueries;
    @Inject
    @BatchProperty
    protected Class jobExecutionSelector;
    @Inject
    @BatchProperty
    protected Boolean keepRunningJobExecutions;
    @Inject
    @BatchProperty
    protected Set<Long> jobExecutionIds;
    @Inject
    @BatchProperty
    protected Integer numberOfRecentJobExecutionsToKeep;
    @Inject
    @BatchProperty
    protected Long jobExecutionIdFrom;
    @Inject
    @BatchProperty
    protected Long jobExecutionIdTo;
    @Inject
    @BatchProperty
    protected Integer withinPastMinutes;
    @Inject
    @BatchProperty
    protected Date jobExecutionEndTimeFrom;
    @Inject
    @BatchProperty
    protected Date jobExecutionEndTimeTo;
    @Inject
    @BatchProperty
    protected Set<String> batchStatuses;
    @Inject
    @BatchProperty
    protected Set<String> exitStatuses;
    @Inject
    @BatchProperty
    protected Set<String> jobExecutionsByJobNames;
    @Inject
    @BatchProperty
    protected Set<String> purgeJobsByNames;

    public String process() throws Exception {
        JdbcRepository jdbcRepository;
        JobContextImpl jobContextImpl = (JobContextImpl)this.jobContext;
        JobRepository jobRepository = jobContextImpl.getJobRepository();
        if (this.purgeJobsByNames != null && !this.purgeJobsByNames.isEmpty()) {
            boolean purgeAll = this.purgeJobsByNames.size() == 1 && this.purgeJobsByNames.contains("*");
            String currentJobName = this.jobContext.getJobName();
            for (String n : jobRepository.getJobNames()) {
                if (!this.purgeJobsByNames.contains(n) && (!purgeAll || currentJobName.equals(n))) continue;
                jobRepository.removeJob(n);
            }
        } else {
            JobExecutionSelector selector;
            if (this.jobExecutionSelector != null) {
                selector = (JobExecutionSelector)this.jobExecutionSelector.newInstance();
            } else {
                DefaultJobExecutionSelector selector1 = new DefaultJobExecutionSelector(this.keepRunningJobExecutions);
                selector1.jobExecutionIds = this.jobExecutionIds;
                selector1.numberOfRecentJobExecutionsToExclude = this.numberOfRecentJobExecutionsToKeep;
                selector1.jobExecutionIdFrom = this.jobExecutionIdFrom;
                selector1.jobExecutionIdTo = this.jobExecutionIdTo;
                selector1.withinPastMinutes = this.withinPastMinutes;
                selector1.jobExecutionEndTimeFrom = this.jobExecutionEndTimeFrom;
                selector1.jobExecutionEndTimeTo = this.jobExecutionEndTimeTo;
                selector1.batchStatuses = this.batchStatuses;
                selector1.exitStatuses = this.exitStatuses;
                selector1.jobExecutionsByJobNames = this.jobExecutionsByJobNames;
                selector = selector1;
            }
            selector.setJobContext(this.jobContext);
            selector.setStepContext(this.stepContext);
            jobRepository.removeJobExecutions(selector);
        }
        if (this.sql != null) {
            this.sql = this.sql.trim();
            if (this.sql.isEmpty()) {
                this.sql = null;
            }
        }
        if (this.sqlFile != null) {
            this.sqlFile = this.sqlFile.trim();
            if (this.sqlFile.isEmpty()) {
                this.sqlFile = null;
            }
        }
        if ((this.sql != null || this.sqlFile != null) && (jdbcRepository = this.getJdbcRepository(jobRepository)) != null) {
            jdbcRepository.executeStatements(this.sql, this.sqlFile);
        }
        if (this.mongoRemoveQueries != null && jobRepository instanceof MongoRepository) {
            ((MongoRepository)jobRepository).executeRemoveQueries(this.mongoRemoveQueries);
        }
        return null;
    }

    public void stop() throws Exception {
    }

    protected JdbcRepository getJdbcRepository(JobRepository repo) {
        if (repo instanceof JdbcRepository) {
            return (JdbcRepository)repo;
        }
        if (repo instanceof InMemoryRepository || repo instanceof MongoRepository || repo instanceof InfinispanRepository) {
            return null;
        }
        try {
            Object result;
            Method getDelegateMethod = repo.getClass().getDeclaredMethod("getDelegate", new Class[0]);
            if (!getDelegateMethod.isAccessible()) {
                getDelegateMethod.setAccessible(true);
            }
            return (result = getDelegateMethod.invoke((Object)repo, new Object[0])) instanceof JdbcRepository ? (JdbcRepository)result : null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failedToGetJdbcRepository(e);
        }
    }
}

