/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import org.jberet.job.model.Chunk;
import org.jberet.job.model.Step;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.runner.AbstractRunner;
import org.jberet.runtime.runner.BatchletRunner;
import org.jberet.runtime.runner.ChunkRunner;
import org.jberet.runtime.runner.StepExecutionRunner;
import org.jberet.runtime.runner.ThreadPartitionWorker;
import org.jberet.spi.PartitionHandler;

public class ThreadPartitionHandler
implements PartitionHandler {
    private StepExecutionRunner stepExecutionRunner;
    private BlockingQueue<Boolean> completedPartitionThreads;
    private BlockingQueue<Serializable> collectorDataQueue;

    public ThreadPartitionHandler(StepExecutionRunner stepExecutionRunner) {
        this.stepExecutionRunner = stepExecutionRunner;
    }

    @Override
    public void setResourceTracker(BlockingQueue<Boolean> completedPartitionThreads) {
        this.completedPartitionThreads = completedPartitionThreads;
    }

    @Override
    public void setCollectorDataQueue(BlockingQueue<Serializable> collectorDataQueue) {
        this.collectorDataQueue = collectorDataQueue;
    }

    @Override
    public void submitPartitionTask(StepContextImpl partitionStepContext, int currentIndex, int numOfPartitions) {
        Step step1 = partitionStepContext.getStep();
        Chunk ch = step1.getChunk();
        ThreadPartitionWorker partitionWorker = new ThreadPartitionWorker(this.completedPartitionThreads, this.collectorDataQueue);
        AbstractRunner runner1 = ch == null ? new BatchletRunner(partitionStepContext, this.stepExecutionRunner.enclosingRunner, step1.getBatchlet(), partitionWorker) : new ChunkRunner(partitionStepContext, this.stepExecutionRunner.enclosingRunner, ch, this.stepExecutionRunner.tm, partitionWorker);
        this.stepExecutionRunner.jobContext.getBatchEnvironment().submitTask(runner1);
    }
}

