/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Locale;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.access.AuthorizerConfiguration;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.access.rbac.RoleMapper;
import org.jboss.as.controller.access.rbac.StandardRBACAuthorizer;
import org.jboss.as.controller.access.rbac.StandardRoleMapper;
import org.jboss.as.controller.access.rbac.SuperUserRoleMapper;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.access.RbacSanityCheckOperation;
import org.jboss.dmr.ModelNode;

class AccessAuthorizationProviderWriteAttributeHander
extends AbstractWriteAttributeHandler<Void> {
    private final DelegatingConfigurableAuthorizer configurableAuthorizer;

    AccessAuthorizationProviderWriteAttributeHander(DelegatingConfigurableAuthorizer configurableAuthorizer) {
        super(new AttributeDefinition[]{AccessAuthorizationResourceDefinition.PROVIDER});
        this.configurableAuthorizer = configurableAuthorizer;
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
        AccessAuthorizationResourceDefinition.Provider provider = AccessAuthorizationResourceDefinition.Provider.valueOf(newValue.asString().toUpperCase(Locale.ENGLISH));
        if (provider == AccessAuthorizationResourceDefinition.Provider.RBAC) {
            RbacSanityCheckOperation.addOperation(context);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        if (!resolvedValue.equals(currentValue)) {
            if (!context.isBooting()) {
                return true;
            }
            AccessAuthorizationProviderWriteAttributeHander.updateAuthorizer(resolvedValue, this.configurableAuthorizer);
        }
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        AccessAuthorizationProviderWriteAttributeHander.updateAuthorizer(valueToRestore, this.configurableAuthorizer);
    }

    static void updateAuthorizer(ModelNode value, DelegatingConfigurableAuthorizer configurableAuthorizer) {
        ModelNode resolvedValue = value.isDefined() ? value : AccessAuthorizationResourceDefinition.PROVIDER.getDefaultValue();
        String providerName = resolvedValue.asString().toUpperCase(Locale.ENGLISH);
        AccessAuthorizationResourceDefinition.Provider provider = AccessAuthorizationResourceDefinition.Provider.valueOf(providerName);
        WritableAuthorizerConfiguration authorizerConfiguration = configurableAuthorizer.getWritableAuthorizerConfiguration();
        Object roleMapper = provider == AccessAuthorizationResourceDefinition.Provider.SIMPLE ? new SuperUserRoleMapper((AuthorizerConfiguration)authorizerConfiguration) : new StandardRoleMapper((AuthorizerConfiguration)configurableAuthorizer.getWritableAuthorizerConfiguration());
        StandardRBACAuthorizer delegate = StandardRBACAuthorizer.create((AuthorizerConfiguration)configurableAuthorizer.getWritableAuthorizerConfiguration(), (RoleMapper)roleMapper);
        configurableAuthorizer.setDelegate((Authorizer)delegate);
    }
}

