/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.codec;

import org.cryptacular.codec.AbstractBaseNEncoder;

public class Base64Encoder
extends AbstractBaseNEncoder {
    private static final char[] DEFAULT_ENCODING_TABLE = new char[64];
    private static final char[] URLSAFE_ENCODING_TABLE = new char[64];

    public Base64Encoder() {
        this(-1);
    }

    public Base64Encoder(boolean urlSafe) {
        this(urlSafe, -1);
    }

    public Base64Encoder(int charactersPerLine) {
        this(false, charactersPerLine);
    }

    public Base64Encoder(boolean urlSafe, int charactersPerLine) {
        super(urlSafe ? URLSAFE_ENCODING_TABLE : DEFAULT_ENCODING_TABLE, charactersPerLine);
    }

    @Override
    protected int getBlockLength() {
        return 24;
    }

    @Override
    protected int getBitsPerChar() {
        return 6;
    }

    static {
        String defaultCharset = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        for (int i = 0; i < "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".length(); ++i) {
            Base64Encoder.DEFAULT_ENCODING_TABLE[i] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(i);
            Base64Encoder.URLSAFE_ENCODING_TABLE[i] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(i);
        }
        Base64Encoder.URLSAFE_ENCODING_TABLE[62] = 45;
        Base64Encoder.URLSAFE_ENCODING_TABLE[63] = 95;
    }
}

