/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.ModificationStore;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.mapping.Value;
import org.hibernate.type.Type;

public class PropertyAuditingData {
    private String name;
    private String beanName;
    private ModificationStore store;
    private String mapKey;
    private AuditJoinTable joinTable;
    private String accessType;
    private final List<AuditOverride> auditJoinTableOverrides = new ArrayList<AuditOverride>(0);
    private RelationTargetAuditMode relationTargetAuditMode;
    private String auditMappedBy;
    private String relationMappedBy;
    private String positionMappedBy;
    private boolean forceInsertable;
    private boolean usingModifiedFlag;
    private String modifiedFlagName;
    private Value value;
    private boolean syntheic;

    public PropertyAuditingData() {
    }

    public PropertyAuditingData(String name, String accessType, ModificationStore store, RelationTargetAuditMode relationTargetAuditMode, String auditMappedBy, String positionMappedBy, boolean forceInsertable) {
        this(name, accessType, store, relationTargetAuditMode, auditMappedBy, positionMappedBy, forceInsertable, false, null);
    }

    public PropertyAuditingData(String name, String accessType, ModificationStore store, RelationTargetAuditMode relationTargetAuditMode, String auditMappedBy, String positionMappedBy, boolean forceInsertable, boolean syntheic, Value value) {
        this.name = name;
        this.beanName = name;
        this.accessType = accessType;
        this.store = store;
        this.relationTargetAuditMode = relationTargetAuditMode;
        this.auditMappedBy = auditMappedBy;
        this.positionMappedBy = positionMappedBy;
        this.forceInsertable = forceInsertable;
        this.syntheic = syntheic;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Deprecated
    public ModificationStore getStore() {
        return this.store;
    }

    @Deprecated
    public void setStore(ModificationStore store) {
        this.store = store;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public void setMapKey(String mapKey) {
        this.mapKey = mapKey;
    }

    public AuditJoinTable getJoinTable() {
        return this.joinTable;
    }

    public void setJoinTable(AuditJoinTable joinTable) {
        this.joinTable = joinTable;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    public PropertyData getPropertyData() {
        return this.resolvePropertyData(null);
    }

    public PropertyData resolvePropertyData(Type propertyType) {
        return new PropertyData(this.name, this.beanName, this.accessType, this.store, this.usingModifiedFlag, this.modifiedFlagName, this.syntheic, propertyType);
    }

    public PropertyData resolvePropertyData(Type propertyType, Type virtualType) {
        return new PropertyData(this.name, this.beanName, this.accessType, this.store, this.usingModifiedFlag, this.modifiedFlagName, this.syntheic, propertyType, virtualType.getReturnedClass());
    }

    public List<AuditOverride> getAuditingOverrides() {
        return this.auditJoinTableOverrides;
    }

    public String getAuditMappedBy() {
        return this.auditMappedBy;
    }

    public void setAuditMappedBy(String auditMappedBy) {
        this.auditMappedBy = auditMappedBy;
    }

    public String getRelationMappedBy() {
        return this.relationMappedBy;
    }

    public void setRelationMappedBy(String relationMappedBy) {
        this.relationMappedBy = relationMappedBy;
    }

    public String getPositionMappedBy() {
        return this.positionMappedBy;
    }

    public void setPositionMappedBy(String positionMappedBy) {
        this.positionMappedBy = positionMappedBy;
    }

    public boolean isForceInsertable() {
        return this.forceInsertable;
    }

    public void setForceInsertable(boolean forceInsertable) {
        this.forceInsertable = forceInsertable;
    }

    public boolean isUsingModifiedFlag() {
        return this.usingModifiedFlag;
    }

    public void setUsingModifiedFlag(boolean usingModifiedFlag) {
        this.usingModifiedFlag = usingModifiedFlag;
    }

    public String getModifiedFlagName() {
        return this.modifiedFlagName;
    }

    public void setModifiedFlagName(String modifiedFlagName) {
        this.modifiedFlagName = modifiedFlagName;
    }

    public void addAuditingOverride(AuditOverride annotation) {
        if (annotation != null) {
            String overrideName = annotation.name();
            boolean present = false;
            for (AuditOverride current : this.auditJoinTableOverrides) {
                if (!current.name().equals(overrideName)) continue;
                present = true;
                break;
            }
            if (!present) {
                this.auditJoinTableOverrides.add(annotation);
            }
        }
    }

    public void addAuditingOverrides(AuditOverrides annotationOverrides) {
        if (annotationOverrides != null) {
            for (AuditOverride annotation : annotationOverrides.value()) {
                this.addAuditingOverride(annotation);
            }
        }
    }

    public RelationTargetAuditMode getRelationTargetAuditMode() {
        return this.relationTargetAuditMode;
    }

    public void setRelationTargetAuditMode(RelationTargetAuditMode relationTargetAuditMode) {
        this.relationTargetAuditMode = relationTargetAuditMode;
    }

    public boolean isSyntheic() {
        return this.syntheic;
    }

    public Value getValue() {
        return this.value;
    }
}

