/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools.query;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.envers.internal.tools.MutableInteger;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.query.Query;

public class UpdateBuilder {
    private final String entityName;
    private final String alias;
    private final MutableInteger paramCounter;
    private final Parameters rootParameters;
    private final Map<String, Object> updates;

    public UpdateBuilder(String entityName, String alias) {
        this(entityName, alias, new MutableInteger());
    }

    private UpdateBuilder(String entityName, String alias, MutableInteger paramCounter) {
        this.entityName = entityName;
        this.alias = alias;
        this.paramCounter = paramCounter;
        this.rootParameters = new Parameters(alias, "and", paramCounter);
        this.updates = new HashMap<String, Object>();
    }

    public Parameters getRootParameters() {
        return this.rootParameters;
    }

    public void updateValue(String propertyName, Object value) {
        this.updates.put(propertyName, value);
    }

    public void build(StringBuilder sb, Map<String, Object> updateParamValues) {
        sb.append("update ").append(this.entityName).append(" ").append(this.alias);
        sb.append(" set ");
        int i = 1;
        for (String property : this.updates.keySet()) {
            String paramName = this.generateParameterName();
            sb.append(this.alias).append(".").append(property).append(" = ").append(":").append(paramName);
            updateParamValues.put(paramName, this.updates.get(property));
            if (i < this.updates.size()) {
                sb.append(", ");
            }
            ++i;
        }
        if (!this.rootParameters.isEmpty()) {
            sb.append(" where ");
            this.rootParameters.build(sb, updateParamValues);
        }
    }

    private String generateParameterName() {
        return "_u" + this.paramCounter.getAndIncrease();
    }

    public Query toQuery(Session session) {
        StringBuilder querySb = new StringBuilder();
        HashMap<String, Object> queryParamValues = new HashMap<String, Object>();
        this.build(querySb, queryParamValues);
        Query query = session.createQuery(querySb.toString());
        for (Map.Entry paramValue : queryParamValues.entrySet()) {
            query.setParameter((String)paramValue.getKey(), paramValue.getValue());
        }
        return query;
    }
}

